/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.pins.MultiPin;
import io.lumine.mythic.core.skills.pins.Pin;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

@MythicTargeter(author="Ashijin", name="pin", aliases={}, description="Targets the location of a saved pin")
public class PinTargeter
extends ILocationSelector {
    protected PlaceholderString key;
    protected boolean random;

    public PinTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.key = mlc.getPlaceholderString(new String[]{"name", "n", "pin", "p", "key", "k"}, null, new String[0]);
        this.random = mlc.getBoolean(new String[]{"random", "r"}, false);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        if (this.key == null && data.getVariables().has("pin")) {
            targets.add(data.getVariables().getLocation("pin"));
            return targets;
        }
        Optional<Pin> maybePin = this.getPlugin().getPinManager().getPin(this.key.get(data));
        if (maybePin.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Pin {0} is not defined", this.key);
            return targets;
        }
        Pin pin = maybePin.get();
        if (this.random && pin instanceof MultiPin) {
            MultiPin multiPin = (MultiPin)pin;
            ArrayList locations = Lists.newArrayList(pin.getLocations());
            if (locations.size() == 0) {
                return targets;
            }
            Collections.shuffle(locations);
            targets.add(this.mutate(data, (AbstractLocation)locations.get(0)));
        } else {
            for (AbstractLocation pinLocation : pin.getLocations()) {
                targets.add(this.mutate(data, pinLocation));
            }
        }
        return targets;
    }
}

