/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@MythicTargeter(author="Ashijin", name="ownerlocation", aliases={}, description="Targets the caster's owner's location")
public class OwnerLocationTargeter
extends ILocationSelector {
    public OwnerLocationTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        UUID uuid;
        Player player;
        ArrayList<AbstractLocation> targets = new ArrayList<AbstractLocation>();
        if (!(data.getCaster() instanceof ActiveMob)) {
            return targets;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        if (am.getOwnerUUID().isPresent() && (player = Bukkit.getPlayer((UUID)(uuid = am.getOwnerUUID().get()))) != null) {
            targets.add(this.mutate(data, BukkitAdapter.adapt(player).getLocation()));
        }
        return targets;
    }
}

