/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.compatibility.WorldGuardSupport;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

@MythicTargeter(author="Ashijin", name="chunksInWERegion", aliases={"chunksInWGRegion"}, description="Targets the 0,0 chunk corners in a region")
public class ChunksInWERegionTargeter
extends ILocationSelector {
    protected PlaceholderString region;

    public ChunksInWERegionTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.region = mlc.getPlaceholderString(new String[]{"region", "r"}, null, new String[0]);
        if (this.region == null) {
            MythicLogger.errorTargeterConfig(this, mlc, "Region name must be set.");
            return;
        }
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        Optional<WorldGuardSupport> maybeWG = this.getPlugin().getCompatibility().getWorldGuard();
        if (maybeWG.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "WorldGuard compatibility unavailable", new Object[0]);
            return targets;
        }
        WorldGuardPlatform wg = WorldGuard.getInstance().getPlatform();
        AbstractWorld world = data.getCaster().getLocation().getWorld();
        org.bukkit.World bukkitWorld = io.lumine.mythic.bukkit.BukkitAdapter.adapt(world);
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
        RegionManager regionManager = wg.getRegionContainer().get(weWorld);
        String regionName = this.region.get(data).toLowerCase();
        ProtectedRegion region = (ProtectedRegion)regionManager.getRegions().get(regionName);
        if (region == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "WorldGuard region not found", new Object[0]);
            return targets;
        }
        BlockVector3 min2 = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        int minChunkX = min2.getBlockX() >> 4;
        int minChunkZ = min2.getBlockZ() >> 4;
        int maxChunkX = max.getBlockX() >> 4;
        int maxChunkZ = max.getBlockZ() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int baseX = chunkX << 4;
                int baseZ = chunkZ << 4;
                AbstractLocation chunkBaseLocation = new AbstractLocation(world, (double)baseX, 0.0, (double)baseZ);
                targets.add(chunkBaseLocation);
            }
        }
        return targets;
    }
}

