/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles.bullet;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.api.volatilecode.virtual.PacketEntityRenderer;
import io.lumine.mythic.api.volatilecode.virtual.PacketItemDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.compatibility.AbstractModelEngineSupport;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.skills.projectiles.bullet.IItemBulletTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Display;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class DisplayPacketBullet
extends ProjectileBullet {
    @MythicField(name="audience", description="The audience of the effect")
    protected SkillAudience audience;
    @MythicField(name="bulletMaterial", aliases={"material", "mat"}, description="The material to use for TRACKING, BLOCK, ITEM, or MYTHICITEM bullet types", defValue="STONE")
    protected Material bulletMaterial = null;
    @MythicField(name="bulletModel", aliases={"model"}, description="The custom model data of the bullet type", defValue="0")
    protected int bulletModelId = 0;
    @MythicField(name="bulletGeneration", description="A model to generate for the bullet (requires Crucible)")
    protected String bulletGeneration = null;
    @MythicField(name="bulletColor", description="The color of the bullet type if applicable i.e. potion color, leather armor.")
    protected String bulletColor = null;
    @MythicField(name="bulletBillboarding", aliases={"bulletBillboard"}, description="The billboarding for the display bullet.")
    protected String bulletBillboarding = null;
    @MythicField(name="bulletCullingDistance", aliases={"bulletViewDistance", "bulletViewRange"}, description="The bullet's brightness")
    protected int bulletCullingDistance = 50;
    @MythicField(name="bulletCullingHeight", aliases={"cullHeight"}, description="The bullet's display height")
    protected float bulletCullingHeight = 0.0f;
    @MythicField(name="bulletCullingWidth", aliases={"cullWidth"}, description="The bullet's display width")
    protected float bulletCullingWidth = 0.0f;
    @MythicField(name="bulletBrightness", aliases={"bulletBrightnessBlock"}, description="The bullet's brightness")
    protected int bulletBrightnessBlock = -1;
    @MythicField(name="bulletBrightnessSky", description="The bullet's sky light brightness")
    protected int bulletBrightnessSky = -1;
    protected int bulletBrightness = -1;
    @MythicField(name="bulletEnchanted", aliases={"enchanted"}, description="Whether the item should be enchanted or not", defValue="false")
    protected boolean bulletEnchanted;
    @MythicField(name="pitch", description="The pitch rotation", defValue="0")
    final PlaceholderDouble rotationPitch;
    @MythicField(name="yaw", description="The yaw rotation", defValue="0")
    final PlaceholderDouble rotationYaw;
    @MythicField(name="roll", description="The roll rotation", defValue="0")
    final PlaceholderDouble rotationRoll;
    @MythicField(name="rotation", aliases={"rot"}, description="The rotation of the projectile, in the x,y,z format", defValue="0,0,0")
    final String rotationString;
    @MythicField(name="tx", description="The X position translation", defValue="0")
    final PlaceholderDouble translationX;
    @MythicField(name="ty", description="The Y position translation", defValue="0")
    final PlaceholderDouble translationY;
    @MythicField(name="tz", description="The Z position translation", defValue="0")
    final PlaceholderDouble translationZ;
    @MythicField(name="translation", aliases={"pos", "offset"}, description="The translation of the projectile, in the x,y,z format", defValue="0,0,0")
    final String translation;
    @MythicField(name="pitchSpeed", description="The pitch rotation speed", defValue="0")
    final PlaceholderDouble pitchSpeed;
    @MythicField(name="yaw", description="The yaw rotation speed", defValue="0")
    final PlaceholderDouble yawSpeed;
    @MythicField(name="roll", description="The roll rotation speed", defValue="0")
    final PlaceholderDouble rollSpeed;
    @MythicField(name="rotation", aliases={"rot"}, description="The rotation speed of the projectile, in the x,y,z format", defValue="0,0,0")
    final String rotationStringSpeed;
    AbstractVector rotationSpeed;
    @MythicField(name="hideFirstTick", aliases={"hft"}, description="Hides the item for the first tick", defValue="0,0,0")
    final boolean hideFirstTick;
    ItemStack bulletItem;
    NamespacedKey bulletItemModel;
    String bulletSkinTexture;
    @MythicField(name="bulletScale", description="The bullet's size scale")
    protected PlaceholderString bulletScale;
    private PacketItemDisplay.PacketItemDisplayBuilder options;
    private AbstractItemStack bulletItemStack;

    public DisplayPacketBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        super(type, projectile, config);
        this.audience = config.getAudience("audience", "world");
        String strBulletMaterial = config.getString(new String[]{"bulletmaterial", "bulletitem", "material", "mat"}, "LEATHER_BOOTS", new String[0]);
        this.bulletModelId = config.getInteger(new String[]{"bulletmodel", "model"}, 0);
        this.bulletGeneration = config.getString(new String[]{"bulletgeneration", "bulletgen", "generation"}, null, new String[0]);
        this.bulletColor = config.getString(new String[]{"bulletcolor"}, null, new String[0]);
        this.bulletEnchanted = config.getBoolean(new String[]{"bulletEnchanted", "enchanted"}, false);
        this.bulletCullingDistance = config.getInteger(new String[]{"bulletCullingDistance", "bulletViewDistance", "bulletViewRange"}, 50);
        this.bulletCullingHeight = config.getFloat(new String[]{"bulletCullingHeight", "cullHeight"}, 0.0f);
        this.bulletCullingWidth = config.getFloat(new String[]{"bulletCullingWidth", "cullWidth"}, 0.0f);
        this.bulletBillboarding = config.getString(new String[]{"bulletBillboarding", "bulletBillboard"}, Display.Billboard.FIXED.toString(), new String[0]);
        this.bulletBrightnessBlock = config.getInteger(new String[]{"bulletbrightness", "bulletbrightnessblock"}, -1);
        this.bulletBrightnessSky = config.getInteger(new String[]{"bulletbrightnesssky"}, this.bulletBrightnessBlock);
        this.bulletBrightness = this.bulletBrightnessBlock > -1 || this.bulletBrightnessSky > -1 ? this.bulletBrightnessBlock << 4 | this.bulletBrightnessSky << 20 : -1;
        this.rotationPitch = config.getPlaceholderDouble(new String[]{"pitch"}, 0.0, new String[0]);
        this.rotationYaw = config.getPlaceholderDouble(new String[]{"yaw"}, 0.0, new String[0]);
        this.rotationRoll = config.getPlaceholderDouble(new String[]{"roll"}, 0.0, new String[0]);
        this.rotationString = config.getString(new String[]{"rotation", "rot"}, "0,0,0", new String[0]);
        this.translationX = config.getPlaceholderDouble(new String[]{"tx"}, 0.0, new String[0]);
        this.translationY = config.getPlaceholderDouble(new String[]{"ty"}, 0.0, new String[0]);
        this.translationZ = config.getPlaceholderDouble(new String[]{"tz"}, 0.0, new String[0]);
        this.translation = config.getString(new String[]{"translation", "pos", "offset"}, "0,0,0", new String[0]);
        this.pitchSpeed = config.getPlaceholderDouble(new String[]{"pitchSpeed", "ps"}, 0.0, new String[0]);
        this.yawSpeed = config.getPlaceholderDouble(new String[]{"yawSpeed", "ys"}, 0.0, new String[0]);
        this.rollSpeed = config.getPlaceholderDouble(new String[]{"rollSpeed", "rs"}, 0.0, new String[0]);
        this.rotationStringSpeed = config.getString(new String[]{"rotationSpeed", "rotSpeed", "rots"}, "0,0,0", new String[0]);
        this.hideFirstTick = config.getBoolean(new String[]{"hideFirstTick", "hft"}, false);
        this.bulletScale = config.getPlaceholderString(new String[]{"bulletscale", "scale"}, "0.5,0.5,0.5", new String[0]);
        this.bulletColor = config.getString(new String[]{"bulletcolor"}, null, new String[0]);
        this.bulletYOffset = config.getDouble(new String[]{"bulletyoffset", "byoffset", "byo"}, 0.2);
        this.getPlugin().getSkillManager().queueAfterLoad(() -> {
            try {
                Optional<MythicItem> maybeItem = this.getPlugin().getItemManager().getItem(strBulletMaterial);
                if (maybeItem.isPresent()) {
                    MythicItem mythicItem = maybeItem.get();
                    this.bulletMaterial = mythicItem.getMaterial();
                    this.bulletModelId = mythicItem.getCustomModelData();
                    this.bulletItemModel = mythicItem.getItemModel();
                    this.bulletSkinTexture = mythicItem.getSkinURL();
                    this.build();
                    return;
                }
                Optional<AbstractModelEngineSupport> support = this.getPlugin().getCompatibility().getModelEngine();
                if (!strBulletMaterial.contains(":") || !support.isPresent()) {
                    this.bulletItemStack = this.getPlugin().getBootstrap().createItem(strBulletMaterial);
                    this.bulletModelId = config.getInteger(new String[]{"bulletmodel", "model"}, -1);
                } else {
                    support.get().queuePostModelRegistration(() -> {
                        try {
                            String[] mat = strBulletMaterial.split(":");
                            AbstractModelEngineSupport.ModelConfig modelConfig = ((AbstractModelEngineSupport)support.get()).getBoneModel(mat[0], mat[1]);
                            int id = modelConfig.getId();
                            if (id == -1) {
                                throw new Exception();
                            }
                            this.bulletModelId = id;
                            this.bulletMaterial = modelConfig.getMaterial();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.bulletMaterial = Material.STONE;
                        }
                    });
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MythicLogger.errorMechanicConfig(projectile, config, "Specified bullet material does not exist");
                this.bulletMaterial = Material.STONE;
            }
            this.build();
            if (this.bulletGeneration != null && this.getPlugin().getCompatibility().getCrucible().isPresent() && this.getProjectileMechanic().getPack() != null) {
                this.getPlugin().getCompatibility().getCrucible().get().addItemToGeneration(this.getProjectileMechanic().getPack(), this.bulletMaterial, this.bulletModelId, config);
            }
        });
    }

    private void build() {
        if (this.bulletMaterial != null) {
            this.bulletItemStack = BukkitAdapter.adapt(this.bulletMaterial);
        }
        if (this.bulletModelId > -1) {
            this.bulletItemStack.modelData(this.bulletModelId);
        }
        if (this.bulletItemModel != null) {
            this.bulletItemStack.itemModel(this.bulletItemModel);
        }
        if (this.bulletSkinTexture != null) {
            this.bulletItemStack.skullTexture(URI.create(this.bulletSkinTexture));
        }
        if (this.bulletColor != null) {
            this.bulletItemStack.color(this.bulletColor);
        }
        this.bulletItemStack.enchantmentGlow(this.bulletEnchanted);
        if (this.hideFirstTick) {
            this.bulletItem = BukkitAdapter.adapt(this.bulletItemStack);
            this.options = PacketItemDisplay.create().height(Float.valueOf(this.bulletCullingHeight)).width(Float.valueOf(this.bulletCullingWidth)).billboard(this.bulletBillboarding).brightness(this.bulletBrightness);
        } else {
            this.options = PacketItemDisplay.create().item(BukkitAdapter.adapt(this.bulletItemStack)).height(Float.valueOf(this.bulletCullingHeight)).width(Float.valueOf(this.bulletCullingWidth)).billboard(this.bulletBillboarding).brightness(this.bulletBrightness);
        }
        AbstractVector bulletScaleStatic = null;
        if (this.bulletScale.isStatic()) {
            try {
                bulletScaleStatic = new AbstractVector(this.bulletScale.get());
            }
            catch (Throwable ex) {
                bulletScaleStatic = new AbstractVector(0.5, 0.5, 0.5);
                MythicLogger.errorMechanic(this.getProjectileMechanic(), "Invalid bullet scale set: " + this.bulletScale.get());
            }
        }
        if (bulletScaleStatic != null) {
            this.options.scale(bulletScaleStatic);
        }
    }

    @Override
    public ProjectileBullet.BulletTracker create(ProjectileBulletableTracker projectile, AbstractEntity target) {
        return new DisplayPacketBulletTracker(projectile, target);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    AbstractVector parseRotation(String rotationString, PlaceholderDouble pPitch, PlaceholderDouble pYaw, PlaceholderDouble pRoll, SkillMetadata data) {
        double roll;
        double yaw;
        String[] split = rotationString.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (split.length == 3) {
            try {
                x = PlaceholderDouble.of(split[0]).get(data);
                y = PlaceholderDouble.of(split[1]).get(data);
                z = PlaceholderDouble.of(split[2]).get(data);
            }
            catch (NumberFormatException e) {
                MythicLogger.error("Invalid format for " + rotationString + " in " + this.getConfig().getLine());
            }
        } else {
            MythicLogger.error("Invalid format for " + rotationString + " in " + this.getConfig().getLine());
        }
        double pitch = pPitch.get(data);
        if (pitch != 0.0) {
            x = pitch;
        }
        if ((yaw = pYaw.get(data)) != 0.0) {
            y = yaw;
        }
        if ((roll = pRoll.get(data)) != 0.0) {
            z = roll;
        }
        return new AbstractVector(x, y, z);
    }

    public class DisplayPacketBulletTracker
    extends ProjectileBullet.BulletTracker
    implements IItemBulletTracker {
        protected PacketArmorStand mount;
        protected PacketItemDisplay bullet;
        AbstractVector lastRotation;

        public DisplayPacketBulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            super(projectile, target);
            this.lastRotation = new AbstractVector(0, 0, 0);
        }

        @Override
        public void spawn(AbstractLocation start) {
            ItemStack i = BukkitAdapter.adapt(DisplayPacketBullet.this.bulletItemStack);
            AbstractLocation l = start.clone();
            AbstractLocation al = l.clone();
            al.setYaw(0.0f);
            al.setPitch(0.0f);
            this.mount = new PacketArmorStand(al);
            this.bullet = DisplayPacketBullet.this.options.build(l);
            AbstractLocation currentLocation = this.getProjectile().getPreviousLocation();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity();
            Location to = BukkitAdapter.adapt(currentLocation).clone();
            Vector delta = BukkitAdapter.adapt(currentVelocity).normalize().multiply(this.getProjectile().getVelocityMagnitude() / 7.6);
            double yaw = Math.atan2(delta.getX(), delta.getZ());
            double len = delta.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(delta.getY(), len);
            Location loc = to.clone().add(delta);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            this.lastRotation = DisplayPacketBullet.this.parseRotation(DisplayPacketBullet.this.rotationString, DisplayPacketBullet.this.rotationPitch, DisplayPacketBullet.this.rotationYaw, DisplayPacketBullet.this.rotationRoll, this.getProjectile().getData());
            this.bullet.setRotationTransformation((float)this.lastRotation.getX(), (float)this.lastRotation.getY(), (float)this.lastRotation.getZ());
            AbstractVector p = DisplayPacketBullet.this.parseRotation(DisplayPacketBullet.this.translation, DisplayPacketBullet.this.translationX, DisplayPacketBullet.this.translationY, DisplayPacketBullet.this.translationZ, this.getProjectile().getData());
            this.bullet.setTranslationTransformation((float)p.getX(), (float)p.getY(), (float)p.getZ());
            Collection<AbstractPlayer> seen = DisplayPacketBullet.this.audience.get(this.getProjectile().getData(), this.getTarget());
            if (!DisplayPacketBullet.this.bulletScale.isStatic()) {
                AbstractVector scaleVector = new AbstractVector(DisplayPacketBullet.this.bulletScale.get(this.getProjectile().getData()));
                this.bullet.setScale(scaleVector);
            }
            this.mount.getRenderer().setCullingDistance(DisplayPacketBullet.this.bulletCullingDistance);
            this.bullet.getRenderer().setCullingDistance(DisplayPacketBullet.this.bulletCullingDistance);
            this.bullet.getRenderer().spawnWithMount(seen, (PacketEntityRenderer)this.mount.getRenderer());
            Schedulers.async().runLater(() -> this.mount.getRenderer().addPassenger((PacketEntityRenderer)this.bullet.getRenderer()), 1L);
        }

        @Override
        public void tick(AbstractLocation origin) {
            Projectile projectileMechanic;
            SkillMechanic skillMechanic;
            if (this.mount == null || this.bullet == null) {
                return;
            }
            if (DisplayPacketBullet.this.hideFirstTick && this.getProjectile().getTimesRan() == 1) {
                this.bullet.setItem(DisplayPacketBullet.this.bulletItem);
            }
            if (this.getProjectile().getTimesRan() % 5 == 0) {
                this.mount.getRenderer().updateRenderedPlayers();
                this.bullet.getRenderer().updateRenderedPlayers();
            }
            double forwardOffset = (skillMechanic = DisplayPacketBullet.this.getProjectileMechanic()) instanceof Projectile ? ((projectileMechanic = (Projectile)skillMechanic).getTickInterpolation() == 0 ? DisplayPacketBullet.this.bulletForwardOffset : DisplayPacketBullet.this.bulletForwardOffset / (double)projectileMechanic.getTickInterpolation()) : DisplayPacketBullet.this.bulletForwardOffset;
            AbstractLocation currentLocation = this.getProjectile().getCurrentLocation().clone();
            AbstractVector currentVelocity = this.getProjectile().getCurrentVelocity().clone().multiply(forwardOffset);
            AbstractLocation to = currentLocation.clone().add(0.0, DisplayPacketBullet.this.bulletYOffset, 0.0);
            AbstractVector predictionOffset = currentVelocity.clone().multiply(0.4);
            to.add(predictionOffset);
            double yaw = Math.atan2(currentVelocity.getX(), currentVelocity.getZ());
            double len = currentVelocity.getZ() / Math.cos(yaw);
            float pitch = (float)Math.atan2(currentVelocity.getY(), len);
            AbstractLocation loc = to.clone().add(currentVelocity);
            float newYaw = (float)Math.toDegrees(-yaw) + 180.0f;
            float newPitch = (float)Math.toDegrees(-pitch);
            loc.setYaw(newYaw);
            loc.setPitch(newPitch);
            DisplayPacketBullet.this.rotationSpeed = DisplayPacketBullet.this.parseRotation(DisplayPacketBullet.this.rotationStringSpeed, DisplayPacketBullet.this.pitchSpeed, DisplayPacketBullet.this.yawSpeed, DisplayPacketBullet.this.rollSpeed, this.getProjectile().getData());
            this.bullet.setRotation(newYaw, newPitch);
            if (DisplayPacketBullet.this.rotationSpeed.length() > 0.0) {
                this.lastRotation.add(DisplayPacketBullet.this.rotationSpeed);
                this.bullet.setRotationTransformation((float)this.lastRotation.getX(), (float)this.lastRotation.getY(), (float)this.lastRotation.getZ());
            }
            this.bullet.setPosition(loc);
            this.bullet.update();
            this.mount.teleport(loc);
        }

        @Override
        public void despawn() {
            this.mount.destroy();
            this.bullet.destroy();
        }

        @Override
        public void setBulletItemModel(int model) {
            ItemStack item = BukkitAdapter.adapt(DisplayPacketBullet.this.bulletItemStack);
            ItemMeta meta = item.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(model));
            item.setItemMeta(meta);
            this.bullet.setItem(item);
        }
    }
}

