/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.skills.placeholders.PlaceholderTime;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderNumber;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class PlaceholderTimeImpl
extends PlaceholderNumber<Instant>
implements PlaceholderTime {
    public static final Map<Character, Integer> UnitConversionMap = new HashMap<Character, Integer>();

    public static PlaceholderTimeImpl of(String data) {
        return new PlaceholderTimeImpl(data);
    }

    public PlaceholderTimeImpl(String data) {
        super(data);
    }

    @Override
    protected Instant convertNumberToSelfType(double number) {
        return Instant.ofEpochMilli((long)number);
    }

    @Override
    protected Instant convertStringToSelfType(String string) {
        if (string == null || string.isEmpty()) {
            return this.getDefaultValue();
        }
        char lastChar = string.charAt(string.length() - 1);
        Integer unitConversion = UnitConversionMap.get(Character.valueOf(lastChar));
        try {
            if (unitConversion != null) {
                String numericPart = string.substring(0, string.length() - 1);
                long value = Long.parseLong(numericPart);
                return Instant.ofEpochMilli(value * (long)unitConversion.intValue());
            }
            return Instant.ofEpochMilli(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            return this.getDefaultValue();
        }
    }

    @Override
    protected Instant getDefaultValue() {
        return Instant.now();
    }

    @Override
    public boolean isStaticallyEqualTo(Instant value) {
        return false;
    }

    static {
        UnitConversionMap.put(Character.valueOf('t'), 50);
        UnitConversionMap.put(Character.valueOf('s'), 1000);
        UnitConversionMap.put(Character.valueOf('m'), 60000);
        UnitConversionMap.put(Character.valueOf('h'), 3600000);
        UnitConversionMap.put(Character.valueOf('d'), 86400000);
        UnitConversionMap.put(Character.valueOf('w'), 604800000);
    }
}

