/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import net.objecthunter.exp4j.ExpressionBuilder;

public abstract class PlaceholderNumber<T>
extends PlaceholderParser {
    public PlaceholderNumber() {
    }

    public PlaceholderNumber(String string) {
        super(string);
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
    }

    protected abstract T convertNumberToSelfType(double var1);

    protected abstract T convertStringToSelfType(String var1);

    protected abstract T getDefaultValue();

    public T get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public T get(PlaceholderMeta meta) {
        return this.get(meta, meta.getTrigger());
    }

    public T get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    public T get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public T get(PlaceholderMeta meta, AbstractLocation location) {
        return this.get(meta);
    }

    public T get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public T get(PlaceholderMeta meta, AbstractItemStack itemStack) {
        String string = this.parse(meta, itemStack);
        if (string == null) {
            MythicLogger.error("Item placeholder value is null for {0}", itemStack.toString());
            return this.getDefaultValue();
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public T get(MythicSpawner spawner) {
        String string = this.parse(spawner);
        if (string == null) {
            return this.getDefaultValue();
        }
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public T get(PlaceholderContext context) {
        if (context == null) {
            return this.get();
        }
        if (context.meta() != null && context.entity() != null) {
            return this.get(context.meta(), context.entity());
        }
        if (context.meta() != null) {
            return this.get(context.meta());
        }
        if (context.entity() != null) {
            return this.get(context.entity());
        }
        if (context.caster() != null) {
            return this.get(context.caster());
        }
        if (context.spawner() != null) {
            return this.get(context.spawner());
        }
        return this.get();
    }

    protected T handleParsing(String string) {
        if (this.doMath) {
            try {
                return this.convertNumberToSelfType(new ExpressionBuilder(string).operator(Operators.operators).functions(Functions.functions).build().evaluate());
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderInt: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return this.convertStringToSelfType(string);
    }

    public String toString() {
        return this.strValue;
    }

    public boolean isStaticallyEqualTo(int value) {
        return this.isStatic() && this.get() == this.convertNumberToSelfType(value);
    }
}

