/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.types.EntityPlaceholder;
import io.lumine.mythic.core.skills.variables.types.ItemVariable;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicPlaceholder(placeholder="target.item.itemstack")
public class TargetItemStackPlaceholder
implements EntityPlaceholder {
    PlaceholderString slot;

    public TargetItemStackPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        if (args.length == 0) {
            return;
        }
        this.slot = PlaceholderString.of(args[0]);
    }

    @Override
    public String apply(AbstractEntity entity, String args) {
        if (this.slot != null && entity.isPlayer()) {
            ItemStack item;
            String parsedSlot = this.slot != null ? this.slot.get(entity) : "0";
            EquipSlot tempSlot = EquipSlot.of(parsedSlot);
            if (tempSlot != EquipSlot.NONE) {
                AbstractItemStack abstractItemStack;
                Optional<AbstractItemStack> maybeNamedSlotItemStack = tempSlot.get(entity);
                if (maybeNamedSlotItemStack.isEmpty() || !((abstractItemStack = maybeNamedSlotItemStack.get()) instanceof BukkitItemStack)) {
                    return "UNDEFINED";
                }
                BukkitItemStack bukkitItemStack = (BukkitItemStack)abstractItemStack;
                item = bukkitItemStack.getItemStack();
            } else {
                int slot = Integer.parseInt(parsedSlot);
                Player player = BukkitAdapter.adapt(entity.asPlayer());
                item = player.getInventory().getItem(slot < 41 ? slot : 0);
            }
            return ItemVariable.Utils.serializeRawToString(item);
        }
        Entity entity2 = entity.getBukkitEntity();
        if (!(entity2 instanceof Item)) {
            return ItemVariable.Utils.getDefaultMaterialSerialized();
        }
        Item itemEntity = (Item)entity2;
        return ItemVariable.Utils.serializeRawToString(itemEntity.getItemStack());
    }
}

