/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.types.GeneralPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.time.Instant;
import java.time.temporal.ChronoField;

@MythicPlaceholder(placeholder="utils.epoch", version="5.9", description="Returns the current epoch time in seconds")
public class EpochPlaceholder
implements GeneralPlaceholder {
    public EpochPlaceholder(PlaceholderExecutor manager) {
    }

    @Override
    public String apply(String s2) {
        switch (s2.toLowerCase()) {
            case "seconds": {
                return String.valueOf(Instant.now().getEpochSecond());
            }
            case "millis": {
                return String.valueOf(Instant.now().getLong(ChronoField.MILLI_OF_SECOND));
            }
            case "ticks": {
                return String.valueOf(Instant.now().getEpochSecond() * 20L + Instant.now().getLong(ChronoField.MILLI_OF_SECOND) / 50L);
            }
            case "timestamp": {
                return String.valueOf(Instant.now().toEpochMilli());
            }
        }
        return String.valueOf(Instant.now().getEpochSecond());
    }
}

