/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.metadata.Pair;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConditionalPlaceholder
implements MetaPlaceholder {
    private final PlaceholderExecutor manager;
    private List<Pair<PlaceholderString, List<SkillCondition>>> values = Lists.newArrayList();
    private PlaceholderString defaultValue;

    public ConditionalPlaceholder(PlaceholderExecutor manager, String key, MythicConfig config) {
        this.manager = manager;
        ((MythicBukkit)manager.getPlugin()).getSkillManager().queueSecondPass(() -> {
            this.defaultValue = config.getPlaceholderString("Default", null);
            for (String node : config.getKeys()) {
                if (node.equals("Default")) continue;
                MythicConfig nestedConfig = config.getNestedConfig(node);
                PlaceholderString value = nestedConfig.getPlaceholderString("Value");
                ArrayList conditions = Lists.newArrayList();
                for (String line : nestedConfig.getStringList("Conditions")) {
                    conditions.add(((MythicBukkit)manager.getPlugin()).getSkillManager().getCondition(line));
                }
                this.values.add(Pair.of(value, conditions));
            }
        });
    }

    @Override
    public String apply(PlaceholderMeta meta, String input) {
        for (Pair<PlaceholderString, List<SkillCondition>> entry : this.values) {
            SkillMetadata skillMetadata;
            Iterator<SkillCondition> iterator = entry.getValue().iterator();
            if (!iterator.hasNext()) continue;
            SkillCondition condition = iterator.next();
            if (meta instanceof SkillMetadata && !condition.evaluateCaster(skillMetadata = (SkillMetadata)meta)) continue;
            return entry.getKey().get(meta);
        }
        return this.defaultValue.get(meta);
    }
}

