/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;

@MythicPlaceholder(placeholder="bar", version="5.2")
public class BarPlaceholder
implements MetaPlaceholder {
    private MythicLineConfig config;
    private BarType barType = BarType.PROGRESS;
    private PlaceholderDouble value;
    private PlaceholderDouble maxValue;
    private PlaceholderInt length;
    private PlaceholderString baseChar;
    private PlaceholderString fillChar;
    private PlaceholderString basePrefix;
    private PlaceholderString fillPrefix;

    public BarPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        String barType = config.getKey().toUpperCase();
        try {
            this.barType = BarType.valueOf(barType);
        }
        catch (Error | Exception ex) {
            this.barType = BarType.PROGRESS;
        }
        this.value = config.getPlaceholderDouble(new String[]{"value", "v"}, 0.0, new String[0]);
        this.maxValue = config.getPlaceholderDouble(new String[]{"maxvalue", "mv", "max"}, 100.0, new String[0]);
        this.length = config.getPlaceholderInteger(new String[]{"length", "len", "l"}, 100, new String[0]);
        this.baseChar = config.getPlaceholderString(new String[]{"remainingSymbol", "remaining", "r", "char", "c"}, "|", new String[0]);
        this.fillChar = config.getPlaceholderString(new String[]{"progressSymbol", "progress", "p"}, this.baseChar.toString(), new String[0]);
        this.basePrefix = config.getPlaceholderString(new String[]{"remainingPrefix", "rp"}, "<gray>", new String[0]);
        this.fillPrefix = config.getPlaceholderString(new String[]{"progressPrefix", "pp"}, "<green>", new String[0]);
    }

    @Override
    public String apply(PlaceholderMeta meta, String input) {
        switch (this.barType.ordinal()) {
            case 0: {
                return this.getProgressBar(meta);
            }
            case 1: {
                return this.getReverseBar(meta);
            }
        }
        return this.getProgressBar(meta);
    }

    private String getProgressBar(PlaceholderMeta meta) {
        int i;
        double value = this.value.get(meta);
        double maxValue = this.maxValue.get(meta);
        double percent = value / maxValue;
        int length = this.length.get(meta);
        int gray = (int)Math.floor(percent * (double)length);
        int rest = length - gray;
        String baseChar = this.baseChar.get(meta);
        String fillChar = this.fillChar.get(meta);
        StringBuilder line = new StringBuilder().append(this.fillPrefix.get(meta));
        for (i = 0; i < gray; ++i) {
            line.append(fillChar);
        }
        line.append(this.basePrefix.get(meta));
        for (i = 0; i < rest; ++i) {
            line.append(baseChar);
        }
        return line.toString();
    }

    private String getReverseBar(PlaceholderMeta meta) {
        int i;
        double value = this.value.get(meta);
        double maxValue = this.maxValue.get(meta);
        double percent = value / maxValue;
        int length = this.length.get(meta);
        int rest = (int)Math.floor(percent * (double)length);
        int gray = length - rest;
        String baseChar = this.baseChar.get(meta);
        String fillChar = this.fillChar.get(meta);
        StringBuilder line = new StringBuilder().append(this.fillPrefix.get(meta));
        for (i = 0; i < gray; ++i) {
            line.append(fillChar);
        }
        line.append(this.basePrefix.get(meta));
        for (i = 0; i < rest; ++i) {
            line.append(baseChar);
        }
        return line.toString();
    }

    private static enum BarType {
        PROGRESS,
        REVERSE;

    }
}

