/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemMatcher;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemMatcher;
import io.lumine.mythic.bukkit.events.MythicModifiedInventoryEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.MetaVariableMechanic;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.types.ItemVariable;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="takeitem", aliases={"take", "takeitems", "itemtake"}, description="Takes an item from the target")
public class TakeItemMechanic
extends MetaVariableMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private final AbstractItemMatcher item;
    private final PlaceholderInt amount;
    private boolean exact;

    public TakeItemMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.item = ((MythicBukkit)this.getPlugin()).getBootstrap().getItemMatcher(mlc);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        if (this.variableName != null) {
            PlaceholderContext context = PlaceholderContext.of(data, target, null);
            this.removeVariableItem(context, (Inventory)player.getInventory(), this.amount.get(data, target));
        } else {
            this.removeItem(data, target, (Inventory)player.getInventory(), this.amount.get(data, target));
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Container)) {
            return SkillResult.INVALID_TARGET;
        }
        Container container = (Container)blockState;
        if (this.variableName != null) {
            PlaceholderContext context = PlaceholderContext.of(data, null, target);
            this.removeVariableItem(context, container.getInventory(), this.amount.get(data));
        } else {
            this.removeItem(data, null, container.getInventory(), this.amount.get(data));
        }
        return SkillResult.SUCCESS;
    }

    private void removeItem(SkillMetadata data, AbstractEntity target, Inventory inventory, int amountToRemove) {
        int slotAmount;
        ItemStack inventoryItem;
        BukkitItemMatcher matcher = (BukkitItemMatcher)this.item;
        for (int i = 0; !(i >= inventory.getSize() || (inventoryItem = inventory.getItem(i)) != null && matcher.matches(inventoryItem) && (amountToRemove = Math.max(0, amountToRemove - (slotAmount = this.executeRemoval(data, target, inventoryItem, amountToRemove)))) == 0); ++i) {
        }
    }

    private void removeVariableItem(PlaceholderContext context, Inventory inventory, int amountToRemove) {
        int slotAmount;
        ItemStack inventoryItem;
        Variable var = this.getVariable(context);
        if (!(var instanceof ItemVariable)) {
            return;
        }
        ItemVariable itemVariable = (ItemVariable)var;
        ItemStack targetItem = itemVariable.getValueClone().getItemStack();
        targetItem.setAmount(1);
        for (int i = 0; !(i >= inventory.getSize() || (inventoryItem = inventory.getItem(i)) != null && targetItem.isSimilar(inventoryItem) && (amountToRemove = Math.max(0, amountToRemove - (slotAmount = this.executeRemoval(context.meta(), context.entity(), inventoryItem, amountToRemove)))) == 0); ++i) {
        }
    }

    private int executeRemoval(PlaceholderMeta data, AbstractEntity target, ItemStack inventoryItem, int amountToRemove) {
        int slotAmount = inventoryItem.getAmount();
        int newAmount = Math.max(0, slotAmount - amountToRemove);
        if (newAmount == 0) {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(inventoryItem);
            if (target != null && target.isPlayer()) {
                AbstractPlayer player = target.asPlayer();
                player.updateInventory();
                Events.call(new MythicModifiedInventoryEvent(data.getCaster(), BukkitAdapter.adapt(player)));
            }
        } else {
            inventoryItem.setAmount(newAmount);
        }
        return slotAmount;
    }
}

