/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="summonPassenger", aliases={"passenger", "summonRider", "rider"}, description="Summons a mob riding the caster")
public class SummonPassengerMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected MythicMob mount;
    protected String strType;
    private boolean stack;

    public SummonPassengerMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getString(new String[]{"passenger", "p", "rider", "r", "type", "t"});
        this.stack = mlc.getBoolean(new String[]{"stack", "s"}, false);
        this.mount = MythicBukkit.inst().getMobManager().getMythicMob(this.strType).orElseGet(() -> null);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        AbstractEntity mountEntity;
        if (this.mount == null) {
            this.mount = MythicBukkit.inst().getMobManager().getMythicMob(this.strType).orElseGet(() -> null);
            if (this.mount == null) {
                MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
                return SkillResult.INVALID_CONFIG;
            }
        }
        if ((mountEntity = this.mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON).getEntity()) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        AbstractEntity mounting = data.getCaster().getEntity();
        if (this.stack && mounting.getPassenger() != null) {
            AbstractEntity current = mounting.getPassenger();
            mounting.setPassenger(current);
            current.setPassenger(mountEntity);
        } else {
            mounting.setPassenger(mountEntity);
        }
        MythicBukkit.inst().getMobManager().getActiveMob(mountEntity.getUniqueId()).get().setOwnerUUID(data.getCaster().getEntity().getUniqueId());
        return SkillResult.SUCCESS;
    }
}

