/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.menu.EditableIcon;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.MenuHelper;
import io.lumine.mythic.bukkit.utils.menu.ReloadableMenu;
import io.lumine.mythic.core.menus.custom.CustomMenu;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Optional;
import org.bukkit.entity.Player;

@MythicMechanic(name="SetCustomMenuButton", description="Opens a custom menu")
public class SetCustomMenuButtonMechanic
extends SkillMechanic
implements INoTargetSkill {
    private PlaceholderInt slot;
    private PlaceholderString icon;

    public SetCustomMenuButtonMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.slot = mlc.getPlaceholderInteger(new String[]{"slot", "s"}, 0, new String[0]);
        this.icon = mlc.getPlaceholderString(new String[]{"icon", "i"}, "default", new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        ReloadableMenu reloadableMenu;
        Player player = BukkitAdapter.adapt(data.getCaster().getEntity().asPlayer());
        MenuHelper.OpenMenu<?> openMenu = MenuHelper.getOpenMenu(player);
        if (openMenu.getMenu().getHolder() == null || !((reloadableMenu = openMenu.getMenu().getHolder()) instanceof CustomMenu)) {
            return SkillResult.INVALID_TARGET;
        }
        CustomMenu rpgMenu = (CustomMenu)reloadableMenu;
        Optional icon = openMenu.getMenu().getBuilder().getIcon(this.icon.get(data));
        if (icon == null || icon.isEmpty()) {
            return SkillResult.INVALID_CONFIG;
        }
        this.setIcon(data, openMenu, this.slot.get(data), icon.get());
        return SkillResult.SUCCESS;
    }

    private <T> void setIcon(SkillMetadata data, MenuHelper.OpenMenu openMenu, int slot, EditableIcon<T> editableIcon) {
        Icon<T> icon = editableIcon.getBuilder().build();
        openMenu.setIcon(this.slot.get(data), icon);
    }

    @Override
    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public boolean getTargetsSpectators() {
        return true;
    }

    @Override
    public boolean getTargetsCreatives() {
        return true;
    }
}

