/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="mount", aliases={"vehicle"}, description="Summons a vehicle for the caster")
public class MountMechanic
extends SkillMechanic
implements INoTargetSkill {
    @MythicField(name="strType", aliases={"mob", "m", "type", "t"}, defValue="", description="The type of mob to mount.")
    private PlaceholderString strType;
    private boolean stack;

    public MountMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getPlaceholderString(new String[]{"mob", "m", "type", "t"}, "", new String[0]);
        this.stack = mlc.getBoolean(new String[]{"stack", "s"}, false);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        AbstractEntity current;
        MythicMob mount = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMob(this.strType.get(data)).orElseGet(() -> null);
        if (mount == null) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
            return SkillResult.INVALID_CONFIG;
        }
        ActiveMob mountMob = mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON);
        AbstractEntity mountEntity = mountMob.getEntity();
        if (mountMob == null || mountEntity == null) {
            return SkillResult.ERROR;
        }
        AbstractEntity mounting = data.getCaster().getEntity();
        if (this.stack && (current = mounting.getVehicle()) != null) {
            mounting.leaveVehicle();
            current.setPassenger(mountEntity);
        }
        mountEntity.setPassenger(mounting);
        mountMob.setOwnerUUID(mounting.getUniqueId());
        mountMob.setParent(data.getCaster());
        return SkillResult.SUCCESS;
    }
}

