/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

@MythicMechanic(author="Ashijin", name="modifyglobalscore", aliases={"mgs"}, description="")
public class ModifyGlobalScoreMechanic
extends SkillMechanic
implements INoTargetSkill {
    @MythicField(name="objective", aliases={"obj", "o"}, defValue="", description="The objective to modify.")
    protected PlaceholderString objective;
    @MythicField(name="action", aliases={"a"}, defValue="ADD", description="The action to perform for modifying the global score.")
    protected ModifyScoreAction action;
    @MythicField(name="value", aliases={"v"}, description="The value to use for the modification.")
    protected int value;

    public ModifyGlobalScoreMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.objective = PlaceholderString.of(mlc.getString(new String[]{"objective", "obj", "o"}, "", new String[0]));
        this.value = mlc.getInteger(new String[]{"value", "v"});
        String strAction = mlc.getString(new String[]{"action", "a"}, "ADD", new String[0]);
        try {
            this.action = ModifyScoreAction.valueOf(strAction.toUpperCase());
        }
        catch (Exception ex) {
            this.action = ModifyScoreAction.ADD;
        }
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        String fobjective;
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(fobjective = this.objective.get(data));
        if (objective == null) {
            objective = scoreboard.registerNewObjective(fobjective, "dummy");
        }
        Score score = objective.getScore("__GLOBAL__");
        score.setScore(this.applyModifier(score.getScore()));
        return SkillResult.SUCCESS;
    }

    protected int applyModifier(int score) {
        if (this.action == ModifyScoreAction.SET) {
            score = this.value;
        } else if (this.action == ModifyScoreAction.ADD) {
            score += this.value;
        } else if (this.action == ModifyScoreAction.SUBTRACT) {
            score -= this.value;
        } else if (this.action == ModifyScoreAction.MULTIPLY) {
            score *= this.value;
        } else if (this.action == ModifyScoreAction.DIVIDE) {
            score /= this.value;
        } else if (this.action == ModifyScoreAction.MOD) {
            score %= this.value;
        }
        return score;
    }

    protected static enum ModifyScoreAction {
        SET,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MOD;

    }
}

