/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

@MythicMechanic(author="Ashijin", name="look", description="Forces the caster to look at the target location")
public class LookMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="headOnly", aliases={"ho"}, description="Only rotate the head of the mob", defValue="false")
    protected boolean headOnly;
    @MythicField(name="immediately", aliases={"immediate", "i"}, description="Causes the mob to turn towards the target immediate without any animations", defValue="true")
    protected boolean immediately;
    @MythicField(name="force", aliases={"f"}, description="Forces the mob to look at the target", defValue="false")
    protected boolean force;
    @MythicField(name="forcePaper", aliases={"fp"}, description="Whether to use PaperMC's method to force the mob to look at the target", defValue="false")
    protected boolean forcePaper;
    @MythicField(name="speed", aliases={"s", "duration", "ticks"}, description="Ticks to fully rotate toward the target for no-AI entities. 1 or less = instant.", defValue="10")
    protected int speedTicks;

    public LookMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.headOnly = mlc.getBoolean(new String[]{"headonly", "ho"}, false);
        this.immediately = mlc.getBoolean(new String[]{"immediately", "immediate", "i"}, true);
        this.force = mlc.getBoolean(new String[]{"force", "f"}, false);
        this.forcePaper = mlc.getBoolean(new String[]{"forcepaper", "fp"}, false);
        this.speedTicks = Math.max(1, mlc.getInteger(new String[]{"speed", "s", "duration", "ticks"}, 10));
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            this.point(target.getLocation(), armorStand);
        } else if (this.force) {
            this.forceLook(data, target.getLocation());
        } else if (this.forcePaper) {
            data.getCaster().getEntity().lookAt(target);
        } else if (!data.getCaster().getEntity().hasAI()) {
            this.simulateLookingAtLocation(data.getCaster().getEntity(), target);
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().lookAtEntity(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            this.point(target, armorStand);
        } else if (this.force) {
            this.forceLook(data, target);
        } else if (this.forcePaper) {
            data.getCaster().getEntity().lookAt(target);
        } else if (!data.getCaster().getEntity().hasAI()) {
            this.simulateLookingAtLocation(data.getCaster().getEntity(), target);
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().lookAtLocation(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        }
        return SkillResult.SUCCESS;
    }

    public void forceLook(SkillMetadata data, AbstractLocation target) {
        AbstractLocation fromLocation = data.getCaster().getLocation();
        double xDiff = target.getX() - fromLocation.getX();
        double yDiff = target.getY() - fromLocation.getY();
        double zDiff = target.getZ() - fromLocation.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yawRads = Math.acos(xDiff / distanceXZ);
        double pitchRads = Math.acos(yDiff / distanceY);
        double yaw = Math.toDegrees(yawRads);
        double pitch = Math.toDegrees(pitchRads) - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        yaw -= 90.0;
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (entity instanceof ArmorStand) {
            ArmorStand as = (ArmorStand)entity;
            this.point(target, as);
        } else {
            fromLocation.setYaw((float)yaw);
            fromLocation.setPitch((float)pitch);
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(data.getCaster().getEntity(), (float)pitch, (float)yaw);
        }
    }

    private void point(AbstractLocation target, ArmorStand stand) {
        Location location = BukkitAdapter.adapt(target);
        Vector delta = location.toVector().subtract(stand.getLocation().toVector());
        double yaw = Math.atan2(delta.getX(), delta.getZ());
        double len = delta.getZ() / Math.cos(yaw);
        double pitch = Math.atan2(delta.getY() - 1.4375, len);
        stand.setHeadPose(new EulerAngle(-pitch, 0.0, 0.0));
        Location loc = stand.getLocation();
        loc.setYaw((float)Math.toDegrees(-yaw));
        stand.teleport(loc);
    }

    private void simulateLookingAtLocation(AbstractEntity caster, AbstractEntity target) {
        if (caster == null || target == null) {
            return;
        }
        if (this.immediately || this.speedTicks <= 1) {
            this.aimAndSetRotation(caster, target.getLocation());
            return;
        }
        new Animator(caster, target, this.speedTicks);
    }

    private void simulateLookingAtLocation(AbstractEntity caster, AbstractLocation target) {
        if (caster == null || target == null) {
            return;
        }
        if (this.immediately || this.speedTicks <= 1) {
            this.aimAndSetRotation(caster, target);
            return;
        }
        new Animator(caster, target, this.speedTicks);
    }

    private void aimAndSetRotation(AbstractEntity caster, AbstractLocation target) {
        Entity be = caster.getBukkitEntity();
        if (be == null) {
            return;
        }
        Location cur = be.getLocation();
        double eyeY = cur.getY() + LookMechanic.approximateEyeHeight(be);
        double dx = target.getX() - cur.getX();
        double dz = target.getZ() - cur.getZ();
        double dy = target.getY() - eyeY;
        double distXZ = Math.max(1.0E-6, Math.hypot(dx, dz));
        float desiredYaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        float desiredPitch = LookMechanic.clampPitch((float)Math.toDegrees(-Math.atan2(dy, distXZ)));
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(caster, desiredPitch, LookMechanic.wrapYaw(desiredYaw));
    }

    private static float wrapYaw(float yaw) {
        if ((yaw %= 360.0f) >= 180.0f) {
            yaw -= 360.0f;
        }
        if (yaw < -180.0f) {
            yaw += 360.0f;
        }
        return yaw;
    }

    private static float deltaAngle(float current, float target) {
        float d = LookMechanic.wrapYaw(target) - LookMechanic.wrapYaw(current);
        if (d >= 180.0f) {
            d -= 360.0f;
        }
        if (d < -180.0f) {
            d += 360.0f;
        }
        return d;
    }

    private static float clampPitch(float pitch) {
        return Math.max(-89.9f, Math.min(89.9f, pitch));
    }

    private static double approximateEyeHeight(Entity e) {
        double h2;
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            try {
                return le.getEyeHeight();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (h2 = e.getHeight()) > 0.0 ? h2 * 0.85 : 1.5;
    }

    private final class Animator
    implements Runnable,
    Terminable {
        private final TerminableRegistry components = TerminableRegistry.create();
        private final AbstractEntity caster;
        private final AbstractEntity movingTarget;
        private AbstractLocation targetLocation;
        private int ticksRemaining;

        Animator(AbstractEntity caster, AbstractEntity target, int speedTicks) {
            this.caster = caster;
            this.movingTarget = target;
            this.targetLocation = target.getLocation();
            this.ticksRemaining = Math.max(1, speedTicks);
            this.start();
        }

        Animator(AbstractEntity caster, AbstractLocation targetLoc, int speedTicks) {
            this.caster = caster;
            this.movingTarget = null;
            this.targetLocation = targetLoc;
            this.ticksRemaining = Math.max(1, speedTicks);
            this.start();
        }

        private void start() {
            this.components.accept(Schedulers.sync().runRepeating(this, 0L, 1L));
        }

        @Override
        public void run() {
            if (this.caster == null || this.caster.getBukkitEntity() == null || this.caster.isDead()) {
                this.close();
                return;
            }
            if (this.movingTarget != null) {
                if (this.movingTarget.isDead() || this.movingTarget.getBukkitEntity() == null) {
                    this.close();
                    return;
                }
                this.targetLocation = this.movingTarget.getLocation();
            }
            if (this.targetLocation == null) {
                this.close();
                return;
            }
            Location cur = this.caster.getBukkitEntity().getLocation();
            float curYaw = cur.getYaw();
            float curPitch = cur.getPitch();
            double eyeY = cur.getY() + LookMechanic.approximateEyeHeight(this.caster.getBukkitEntity());
            double dx = this.targetLocation.getX() - cur.getX();
            double dz = this.targetLocation.getZ() - cur.getZ();
            double dy = this.targetLocation.getY() - eyeY;
            double distXZ = Math.max(1.0E-6, Math.hypot(dx, dz));
            float desiredYaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
            float desiredPitch = LookMechanic.clampPitch((float)Math.toDegrees(-Math.atan2(dy, distXZ)));
            float dYaw = LookMechanic.deltaAngle(curYaw, desiredYaw);
            float dPitch = desiredPitch - curPitch;
            int stepsLeft = Math.max(1, this.ticksRemaining);
            float stepYaw = dYaw / (float)stepsLeft;
            float stepPitch = dPitch / (float)stepsLeft;
            if (Math.abs(dYaw) < 0.25f) {
                stepYaw = dYaw;
            }
            if (Math.abs(dPitch) < 0.25f) {
                stepPitch = dPitch;
            }
            float newYaw = LookMechanic.wrapYaw(curYaw + stepYaw);
            float newPitch = LookMechanic.clampPitch(curPitch + stepPitch);
            ((MythicBukkit)LookMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.caster, newPitch, newYaw);
            --this.ticksRemaining;
            if (this.ticksRemaining <= 0) {
                ((MythicBukkit)LookMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.caster, desiredPitch, LookMechanic.wrapYaw(desiredYaw));
                this.close();
            }
        }

        @Override
        public void close() {
            this.components.closeAndReportException();
        }
    }
}

