/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ILocationComparisonCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedDouble;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="xdiff", aliases={}, description="Whether the x-difference between the caster and target is within the given range")
public class XDiffCondition
extends SkillCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    @MythicField(name="difference", aliases={"diff", "d"}, description="The difference to match", defValue="0")
    protected RangedDouble diff;

    public XDiffCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"difference", "diff", "d"}, this.conditionVar, new String[0]);
        this.diff = new RangedDouble(d);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        double t2 = target.getLocation().getX();
        double c = entity.getLocation().getX();
        return this.diff.equals(t2 - c);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        double t2 = target.getX();
        double c = location.getX();
        return this.diff.equals(t2 - c);
    }
}

