/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import org.bukkit.entity.Mob;

@MythicCondition(author="Ashijin", name="targetWithin", aliases={}, description="Tests if the target's target is within a certain distance")
public class TargetWithinCondition
extends SkillCondition
implements ISkillMetaComparisonCondition {
    @MythicField(name="distance", aliases={"d"}, description="Distance to check")
    private PlaceholderDouble distance;

    public TargetWithinCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = mlc.getPlaceholderDouble(new String[]{"distance", "d"}, "0", this.conditionVar);
    }

    @Override
    public boolean check(SkillMetadata meta, AbstractEntity entity) {
        if (!entity.isMob()) {
            return true;
        }
        Mob c = (Mob)entity.getBukkitEntity();
        if (c.getTarget() == null) {
            return false;
        }
        if (c.getTarget().getWorld().equals((Object)c.getWorld())) {
            return c.getTarget().getLocation().distanceSquared(c.getLocation()) < Math.pow(this.distance.get(meta, entity), 2.0);
        }
        return false;
    }
}

