/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import java.util.UUID;
import org.bukkit.Bukkit;

@MythicCondition(author="Ashijin", name="ownerIsOnline", aliases={}, description="Checks if the owner of the target mob is online, if the owner is a player")
public class OwnerIsOnlineCondition
extends SkillCondition
implements IEntityCondition {
    public OwnerIsOnlineCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity target) {
        ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(target);
        if (am == null) {
            return false;
        }
        if (am.getOwnerUUID().isPresent()) {
            return Bukkit.getPlayer((UUID)am.getOwnerUUID().get()) != null;
        }
        return false;
    }
}

