/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaLocationComparisonCondition;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.mechanics.MetaSkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import java.util.Optional;

@MythicCondition(author="Lxlp", name="skillCondition", aliases={"metaSkillCondition"}, description="Casts a Metaskill that will determine if the condition should check or not")
public class MetaSkillCondition
extends SkillCondition
implements ISkillMetaComparisonCondition,
ISkillMetaLocationComparisonCondition,
SkillHolder {
    protected final MetaSkillMechanic metaSkillMechanic;
    protected final String internalName;
    public static final String DETERMINATION_KEY = "condition-outcome";

    public MetaSkillCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.internalName = mlc.getKey() + "@" + mlc.getFileName() + ":" + mlc.getLine();
        this.metaSkillMechanic = new MetaSkillMechanic(MetaSkillCondition.getPlugin().getSkillManager(), null, line, mlc);
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public Pack getPack() {
        return null;
    }

    @Override
    public boolean check(SkillMetadata meta, AbstractEntity target) {
        return this.executeCheckLogic(meta, target);
    }

    @Override
    public boolean check(SkillMetadata meta, AbstractLocation target) {
        return this.executeCheckLogic(meta, target);
    }

    public boolean executeCheckLogic(SkillMetadata meta, Object target) {
        Object object;
        if (!this.metaSkillMechanic.hasSkill()) {
            return false;
        }
        SkillMetadata finalMeta = meta.deepClone();
        finalMeta.setMetadata(DETERMINATION_KEY, null);
        if (target instanceof AbstractEntity) {
            AbstractEntity entity = (AbstractEntity)target;
            finalMeta.setEntityTarget(entity);
        } else if (target instanceof AbstractLocation) {
            AbstractLocation location = (AbstractLocation)target;
            finalMeta.setLocationTarget(location);
        }
        MetaSkillMechanic.SkillCastOutput result = this.metaSkillMechanic.castWithOutput(finalMeta);
        if (result == null || result.result() != SkillResult.SUCCESS) {
            return false;
        }
        Optional<Object> outcome = result.dataOut().getMetadata(DETERMINATION_KEY);
        if (outcome.isPresent() && (object = outcome.get()) instanceof Boolean) {
            Boolean returnBoolean = (Boolean)object;
            return returnBoolean;
        }
        return false;
    }
}

