/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractGameMode;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;

@MythicCondition(author="Seyarada", name="gamemode", aliases={"gm"}, description="Matches the target's gamemode")
public class GamemodeCondition
extends SkillCondition
implements IEntityCondition {
    protected AbstractGameMode mode = AbstractGameMode.SURVIVAL;

    public GamemodeCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        String strMode = mlc.getString(new String[]{"mode", "m"}, "SURVIVAL", new String[0]);
        try {
            this.mode = AbstractGameMode.valueOf(strMode.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorCondition(this, "'" + strMode + "' is not a valid GameMode");
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (target.isPlayer()) {
            return target.asPlayer().getGameMode().equals((Object)this.mode);
        }
        return false;
    }
}

