/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.auras;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.auras.AuraAttachmentType;

public abstract class AuraAttachment {
    private final SkillMechanic projectileMechanic;
    private final MythicLineConfig config;

    public AuraAttachment(AuraAttachmentType type, SkillMechanic projectile, MythicLineConfig config) {
        this.projectileMechanic = projectile;
        this.config = config;
    }

    public MythicBukkit getPlugin() {
        if (this.projectileMechanic == null) {
            return MythicBukkit.inst();
        }
        return this.projectileMechanic.getPlugin();
    }

    public abstract AttachmentTracker create(Aura.AuraTracker var1, AbstractEntity var2);

    public abstract boolean isVirtual();

    public SkillMechanic getProjectileMechanic() {
        return this.projectileMechanic;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public abstract class AttachmentTracker {
        private final Aura.AuraTracker aura;
        private final AbstractEntity target;

        public boolean isVirtual() {
            return AuraAttachment.this.isVirtual();
        }

        public abstract void spawn(AbstractEntity var1);

        public abstract void tick();

        public abstract void despawn();

        public AttachmentTracker(Aura.AuraTracker aura, AbstractEntity target) {
            this.aura = aura;
            this.target = target;
        }

        public Aura.AuraTracker getAura() {
            return this.aura;
        }

        public AbstractEntity getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttachmentTracker)) {
                return false;
            }
            AttachmentTracker other = (AttachmentTracker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Aura.AuraTracker this$aura = this.getAura();
            Aura.AuraTracker other$aura = other.getAura();
            if (this$aura == null ? other$aura != null : !this$aura.equals(other$aura)) {
                return false;
            }
            AbstractEntity this$target = this.getTarget();
            AbstractEntity other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttachmentTracker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Aura.AuraTracker $aura = this.getAura();
            result = result * 59 + ($aura == null ? 43 : $aura.hashCode());
            AbstractEntity $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public String toString() {
            return "AuraAttachment.AttachmentTracker(aura=" + String.valueOf(this.getAura()) + ", target=" + String.valueOf(this.getTarget()) + ")";
        }
    }
}

