/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus.mobs;

import io.lumine.mythic.bukkit.utils.menu.Icon;
import io.lumine.mythic.bukkit.utils.menu.MenuData;
import io.lumine.mythic.core.menus.mobs.MobEditorButtons;
import io.lumine.mythic.core.menus.mobs.MobEditorMenuContext;
import java.util.function.Predicate;
import org.bukkit.inventory.ItemStack;

public abstract class MobEditorButton
implements Comparable,
MenuData<MobEditorMenuContext> {
    private final int sortIndex;

    public MobEditorButton(MobEditorButtons parent, int sort) {
        this.sortIndex = sort;
        parent.buttons.add(this);
    }

    @Override
    public abstract Icon<MobEditorMenuContext> getIcon();

    public boolean isApplicable(ItemStack itemStack) {
        return true;
    }

    public boolean isApplicable(ItemStack itemStack, Predicate<ItemStack> predicate) {
        return predicate.test(itemStack);
    }

    public int compareTo(Object o) {
        if (o instanceof MobEditorButton) {
            MobEditorButton button = (MobEditorButton)o;
            return button.getSortIndex() - this.sortIndex;
        }
        return 0;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }
}

