/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.menus;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMenusPreLoadEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.MenuProp;
import io.lumine.mythic.bukkit.utils.files.Files;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.ReloadableMenu;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.menus.ColorPickerMenu;
import io.lumine.mythic.core.menus.MainMenu;
import io.lumine.mythic.core.menus.config.ConfigMenu;
import io.lumine.mythic.core.menus.custom.CustomMenu;
import io.lumine.mythic.core.menus.custom.CustomMenuBindingFunction;
import io.lumine.mythic.core.menus.custom.CustomMenuButtonFunction;
import io.lumine.mythic.core.menus.custom.CustomPlayerMenu;
import io.lumine.mythic.core.menus.items.ItemBrowseMenu;
import io.lumine.mythic.core.menus.items.ItemEditorMenu;
import io.lumine.mythic.core.menus.mobs.MobBrowseMenu;
import io.lumine.mythic.core.menus.mobs.MobEditorMenu;
import io.lumine.mythic.core.menus.spawners.SpawnerBrowseMenu;
import io.lumine.mythic.core.menus.spawners.SpawnerEditorMenu;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class MenuManager
extends ReloadableModule<MythicBukkit> {
    private MainMenu mainMenu;
    private ConfigMenu configMenu;
    private ColorPickerMenu colorPickerMenu;
    private ItemBrowseMenu itemBrowseMenu;
    private ItemEditorMenu itemEditorMenu;
    private MobBrowseMenu mobBrowseMenu;
    private MobEditorMenu mobEditorMenu;
    private SpawnerBrowseMenu spawnerBrowseMenu;
    private SpawnerEditorMenu spawnerEditorMenu;
    private Map<String, CustomMenu> customMenus = Maps.newConcurrentMap();
    private Map<String, ItemFactory> customButtons = Maps.newConcurrentMap();
    private Map<String, Function<MythicConfig, CustomMenuBindingFunction>> customMenuFunctions = Maps.newConcurrentMap();
    private Map<String, Function<MythicConfig, CustomMenuButtonFunction>> customButtonFunctions = Maps.newConcurrentMap();

    public MenuManager(MythicBukkit plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        if (this.mainMenu == null) {
            this.mainMenu = new MainMenu(plugin, this);
            this.configMenu = new ConfigMenu(plugin, this);
            this.itemBrowseMenu = new ItemBrowseMenu(plugin, this);
            this.itemEditorMenu = new ItemEditorMenu(plugin, this);
            this.mobBrowseMenu = new MobBrowseMenu(plugin, this);
            this.mobEditorMenu = new MobEditorMenu(plugin, this);
            this.spawnerBrowseMenu = new SpawnerBrowseMenu(plugin, this);
            this.spawnerEditorMenu = new SpawnerEditorMenu(plugin, this);
        }
        this.mainMenu.reload();
        this.configMenu.reload();
        this.itemBrowseMenu.reload();
        this.itemEditorMenu.reload();
        this.mobBrowseMenu.reload();
        this.mobEditorMenu.reload();
        this.spawnerBrowseMenu.reload();
        this.spawnerEditorMenu.reload();
        this.colorPickerMenu = new ColorPickerMenu();
        ((MythicBukkit)this.getPlugin()).getClock().queueAfterLoad(this::loadCustomMenus);
    }

    @Override
    public void unload() {
    }

    private void loadCustomMenus() {
        this.customMenus.clear();
        Events.call(new MythicMenusPreLoadEvent((MythicBukkit)this.plugin, this));
        for (Pack pack : ((MythicBukkit)this.plugin).getPackManager().getPacks()) {
            File folder = pack.getPackFolder("Menus", false);
            if (!folder.exists() || !folder.isDirectory()) continue;
            for (File file : Files.getAllYaml(folder.getAbsolutePath())) {
                for (String key : (Set)Property.NodeList(this.plugin, file, "").get()) {
                    this.registerCustomMenu(pack, file, key);
                }
            }
        }
    }

    private void registerCustomMenu(Pack pack, File file, String key) {
        if (!this.customMenus.containsKey(key)) {
            MenuProp prop = new MenuProp(this.plugin, file, key, null);
            CustomPlayerMenu customMenu = new CustomPlayerMenu((MythicBukkit)this.plugin, this, pack, file, key, prop);
            this.customMenus.put(key, customMenu);
        }
        this.customMenus.values().forEach(ReloadableMenu::reload);
    }

    public Collection<String> getAvailableMenuNames() {
        return this.customMenus.keySet();
    }

    public Optional<CustomMenu> getMenu(String key) {
        return Optional.ofNullable(this.customMenus.get(key));
    }

    public Optional<CustomMenuBindingFunction> getMenuBindingFunction(String key, MythicConfig config) {
        Function<MythicConfig, CustomMenuBindingFunction> function = this.customMenuFunctions.get(key);
        if (function == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(function.apply(config));
    }

    public Optional<CustomMenuButtonFunction> getMenuButtonFunction(String key, MythicConfig config) {
        Function<MythicConfig, CustomMenuButtonFunction> function = this.customButtonFunctions.get(key);
        if (function == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(function.apply(config));
    }

    public void registerCustomMenuFunction(String[] keys, Function<MythicConfig, CustomMenuBindingFunction> function) {
        for (String key : keys) {
            this.customMenuFunctions.put(key, function);
        }
    }

    public void registerCustomMenuFunction(String key, Function<MythicConfig, CustomMenuBindingFunction> function) {
        this.customMenuFunctions.put(key, function);
    }

    public void registerCustomButtonFunction(String[] keys, Function<MythicConfig, CustomMenuButtonFunction> function) {
        for (String key : keys) {
            this.customButtonFunctions.put(key, function);
        }
    }

    public void registerCustomButtonFunction(String key, Function<MythicConfig, CustomMenuButtonFunction> function) {
        this.customButtonFunctions.put(key, function);
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public ConfigMenu getConfigMenu() {
        return this.configMenu;
    }

    public ColorPickerMenu getColorPickerMenu() {
        return this.colorPickerMenu;
    }

    public ItemBrowseMenu getItemBrowseMenu() {
        return this.itemBrowseMenu;
    }

    public ItemEditorMenu getItemEditorMenu() {
        return this.itemEditorMenu;
    }

    public MobBrowseMenu getMobBrowseMenu() {
        return this.mobBrowseMenu;
    }

    public MobEditorMenu getMobEditorMenu() {
        return this.mobEditorMenu;
    }

    public SpawnerBrowseMenu getSpawnerBrowseMenu() {
        return this.spawnerBrowseMenu;
    }

    public SpawnerEditorMenu getSpawnerEditorMenu() {
        return this.spawnerEditorMenu;
    }
}

