/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.drops.droppables;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.drops.IMultiDrop;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.VanillaItemDrop;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;

public class VanillaDropTableDrop
extends Drop
implements IMultiDrop {
    private LootTable lootTable;

    public VanillaDropTableDrop(String line, MythicLineConfig config) {
        super(line, config);
        LootTables lootTables;
        Object item = this.getDropVar();
        if (!((String)item).contains(":")) {
            item = "minecraft:" + (String)item;
        }
        if ((lootTables = (LootTables)Registry.LOOT_TABLES.get(NamespacedKey.fromString((String)((String)item).toLowerCase()))) == null) {
            return;
        }
        this.lootTable = lootTables.getLootTable();
    }

    @Override
    public LootBag get(DropMetadata meta) {
        LootBag loot = new LootBag(meta);
        if (this.lootTable == null) {
            return loot;
        }
        AbstractLocation location = meta.getCaster() != null ? meta.getCaster().getLocation() : (meta.getCause().isPresent() ? meta.getCause().get().getLocation() : (meta.getTrigger() != null ? meta.getTrigger().getLocation() : new AbstractLocation(((World)Bukkit.getWorlds().get(0)).getName(), 0.0, 0.0, 0.0)));
        LootContext.Builder context = new LootContext.Builder(BukkitAdapter.adapt(location));
        if (meta.getDropper().isPresent()) {
            context.lootedEntity(meta.getDropper().get().getEntity().getBukkitEntity());
        } else {
            context.killer(null);
        }
        if (meta.getCause().isPresent()) {
            Entity entity = meta.getCause().get().getBukkitEntity();
            if (entity instanceof HumanEntity) {
                HumanEntity killer = (HumanEntity)entity;
                context.killer(killer);
            } else {
                context.killer(null);
            }
        } else {
            context.killer(null);
        }
        for (ItemStack item : this.lootTable.populateLoot(new Random(), context.build())) {
            loot.add(meta, new VanillaItemDrop(this.getLine(), this.getConfig(), BukkitAdapter.adapt(item)));
        }
        return loot;
    }

    public LootTable getLootTable() {
        return this.lootTable;
    }
}

