/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.config;

import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.core.logging.MythicLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class IOLoader<T extends JavaPlugin> {
    private T plugin;
    private File file = null;
    private FileConfiguration fileConfig = null;
    private String defaultFile;

    public IOLoader(T plugin, String newfile) {
        this(plugin, newfile, null);
    }

    public IOLoader(T plugin, String newfile, String folder) {
        this.plugin = plugin;
        this.defaultFile = newfile;
        if (folder != null) {
            folder = folder.replace("/", System.getProperty("file.separator"));
            String path = String.valueOf(plugin.getDataFolder()) + System.getProperty("file.separator") + folder.toLowerCase();
            File dir = new File(path);
            if (!dir.exists() && !(dir = new File(path = String.valueOf(plugin.getDataFolder()) + System.getProperty("file.separator") + folder)).exists()) {
                path = String.valueOf(plugin.getDataFolder()) + System.getProperty("file.separator") + folder.toLowerCase();
                dir = new File(path);
                dir.mkdir();
            }
            this.file = new File(path, newfile);
        } else {
            this.file = new File(plugin.getDataFolder(), newfile);
        }
        this.reloadCustomConfig(!this.file.exists() && MythicProvider.get().getConfiguration().getLoadExampleConfigs() != false);
    }

    public IOLoader(T plugin, File newfile, String folder) {
        this.plugin = plugin;
        this.file = newfile;
        this.reloadCustomConfig(this.file == null);
    }

    public void reloadCustomConfig(boolean loadDefaults) {
        if (loadDefaults && this.file != null) {
            this.file = new File(this.file.getParent(), this.defaultFile);
            try {
                this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
            }
            catch (Throwable ex) {
                MythicLogger.errorYMLConfig(this.file, ex.getMessage());
                return;
            }
            InputStream defConfigStream = this.plugin.getResource(this.defaultFile);
            if (defConfigStream != null) {
                InputStreamReader reader = new InputStreamReader(defConfigStream);
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                this.fileConfig.setDefaults((Configuration)defConfig);
            }
            this.getCustomConfig().options().copyDefaults(true);
            MythicLogger.log("File " + this.defaultFile + " not found! Creating a new one...");
            this.saveCustomConfig();
        } else {
            try {
                this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
            }
            catch (Throwable ex) {
                MythicLogger.errorYMLConfig(this.file, ex.getMessage());
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getCustomConfig() {
        if (this.fileConfig == null) {
            this.reloadCustomConfig(this.file == null);
        }
        return this.fileConfig;
    }

    public void saveCustomConfig() {
        if (this.fileConfig == null || this.file == null) {
            return;
        }
        try {
            this.getCustomConfig().save(this.file);
        }
        catch (IOException ex) {
            if (MythicProvider.get().getConfiguration().getDebugLevel() > 0) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.file), ex);
            }
            MythicLogger.error("Severe Error: Could not save config to " + String.valueOf(this.file) + ". Turn on debugging if this error keeps occuring for details.");
        }
    }
}

