/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.terminable.composite;

import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.composite.CompositeClosingException;
import io.lumine.mythic.bukkit.utils.terminable.composite.CompositeTerminable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AbstractWeakCompositeTerminable
implements CompositeTerminable {
    private final Deque<WeakReference<AutoCloseable>> closeables = new ConcurrentLinkedDeque<WeakReference<AutoCloseable>>();

    protected AbstractWeakCompositeTerminable() {
    }

    @Override
    public CompositeTerminable with(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        this.closeables.push(new WeakReference<AutoCloseable>(autoCloseable));
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        WeakReference<AutoCloseable> ref;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ref = this.closeables.poll()) != null) {
            AutoCloseable ac = (AutoCloseable)ref.get();
            if (ac == null) continue;
            try {
                ac.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }

    @Override
    public void cleanup() {
        this.closeables.removeIf(ref -> {
            AutoCloseable ac = (AutoCloseable)ref.get();
            return ac == null || ac instanceof Terminable && ((Terminable)ac).isClosed();
        });
    }
}

