/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.numbers;

public class RangedInt {
    protected final Operation op;
    protected int min;
    protected int max;

    public RangedInt(String value) {
        this(value, false);
    }

    public RangedInt(String value, boolean squared) {
        if (value.startsWith(">=")) {
            s = value.substring(2);
            this.min = Integer.parseInt(s);
            this.max = Integer.MAX_VALUE;
            this.op = Operation.GREATER_THAN_OR_EQUAL;
        } else if (value.startsWith("<=")) {
            s = value.substring(2);
            this.min = Integer.MIN_VALUE;
            this.max = Integer.parseInt(s);
            this.op = Operation.LESS_THAN_OR_EQUAL;
        } else if (value.startsWith(">")) {
            s = value.substring(1);
            this.min = Integer.parseInt(s);
            this.max = Integer.MAX_VALUE;
            this.op = Operation.GREATER_THAN;
        } else if (value.startsWith("<")) {
            s = value.substring(1);
            this.min = Integer.MIN_VALUE;
            this.max = Integer.parseInt(s);
            this.op = Operation.LESS_THAN;
        } else if (value.contains("to")) {
            split = value.split("to");
            this.min = Integer.parseInt(split[0]);
            this.max = Integer.parseInt(split[1]);
            this.op = Operation.RANGE;
        } else if (!value.startsWith("-") && value.contains("-")) {
            split = value.split("-");
            this.min = Integer.parseInt(split[0]);
            this.max = Integer.parseInt(split[1]);
            this.op = Operation.RANGE;
        } else {
            this.max = this.min = Integer.parseInt(value);
            this.op = Operation.EQUALS;
        }
        if (this.min > this.max) {
            int tmp = this.min;
            this.min = this.max;
            this.max = tmp;
        }
        if (squared) {
            this.min *= this.min;
            this.max *= this.max;
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Number)) {
            throw new IllegalArgumentException("Can only compare to a Number");
        }
        int d = ((Number)o).intValue();
        switch (this.op.ordinal()) {
            case 0: {
                return d == this.min;
            }
            case 1: {
                return d > this.min;
            }
            case 2: {
                return d >= this.min;
            }
            case 3: {
                return d < this.max;
            }
            case 4: {
                return d <= this.max;
            }
            case 5: {
                return d >= this.min && d <= this.max;
            }
        }
        return false;
    }

    public String toString() {
        return "RangedInt{min=" + this.min + ", max=" + this.max + ", op=" + String.valueOf((Object)this.op) + "}";
    }

    public static enum Operation {
        EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        RANGE;

    }
}

