/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.menu;

import io.lumine.mythic.bukkit.utils.cooldown.Cooldown;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.menu.Icon;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConditionalIcon<T>
implements Icon<T> {
    private final Icon<T> fallbackIcon;
    private final Map<BiPredicate<T, Player>, Icon<T>> conditionalIcons;
    private final Cooldown updateCooldown = Cooldown.of(1L, TimeUnit.SECONDS);
    private Icon<T> lastIcon = null;

    public ConditionalIcon(Icon<T> fallbackIcon, Map<BiPredicate<T, Player>, Icon<T>> conditionalIcons) {
        this.fallbackIcon = fallbackIcon;
        this.conditionalIcons = conditionalIcons;
    }

    private Icon<T> getIcon(T state, Player player) {
        if (!this.updateCooldown.test()) {
            return this.lastIcon;
        }
        for (Map.Entry<BiPredicate<T, Player>, Icon<T>> entry : this.conditionalIcons.entrySet()) {
            if (!entry.getKey().test(state, player)) continue;
            this.lastIcon = entry.getValue();
            return entry.getValue();
        }
        this.lastIcon = this.fallbackIcon;
        return this.fallbackIcon;
    }

    @Override
    public ItemStack build(T state, Player player) {
        return this.getIcon(state, player).build(state, player);
    }

    @Override
    public ItemFactory getIconFactory(T state, Player player) {
        return this.getIcon(state, player).getIconFactory(state, player);
    }

    @Override
    public int getAmount(T state, Player player) {
        return this.getIcon(state, player).getAmount(state, player);
    }

    @Override
    public boolean isBlinkingIcon() {
        return false;
    }

    @Override
    public long getMonitorTimestamp() {
        return 0L;
    }

    @Override
    public Optional<BiConsumer<T, Player>> getClickFunc() {
        return this.lastIcon.getClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getRightClickFunc() {
        return this.lastIcon.getRightClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getShiftClickFunc() {
        return this.lastIcon.getShiftClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getShiftRightClickFunc() {
        return this.lastIcon.getShiftRightClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getDoubleClickFunc() {
        return this.lastIcon.getDoubleClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getDropClickFunc() {
        return this.lastIcon.getDropClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getDropAllClickFunc() {
        return this.lastIcon.getDropAllClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getMiddleClickFunc() {
        return this.lastIcon.getMiddleClickFunc();
    }

    @Override
    public Optional<BiConsumer<T, Player>> getSwapOffhandClickFunc() {
        return this.lastIcon.getSwapOffhandClickFunc();
    }
}

