/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.math3.stat.interval;

import io.lumine.mythic.bukkit.utils.lib.math3.exception.NotPositiveException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NotStrictlyPositiveException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.NumberIsTooLargeException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.OutOfRangeException;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.util.Localizable;
import io.lumine.mythic.bukkit.utils.lib.math3.exception.util.LocalizedFormats;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.AgrestiCoullInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.BinomialConfidenceInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.ClopperPearsonInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.ConfidenceInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.NormalApproximationInterval;
import io.lumine.mythic.bukkit.utils.lib.math3.stat.interval.WilsonScoreInterval;

public final class IntervalUtils {
    private static final BinomialConfidenceInterval AGRESTI_COULL = new AgrestiCoullInterval();
    private static final BinomialConfidenceInterval CLOPPER_PEARSON = new ClopperPearsonInterval();
    private static final BinomialConfidenceInterval NORMAL_APPROXIMATION = new NormalApproximationInterval();
    private static final BinomialConfidenceInterval WILSON_SCORE = new WilsonScoreInterval();

    private IntervalUtils() {
    }

    public static ConfidenceInterval getAgrestiCoullInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        return AGRESTI_COULL.createInterval(numberOfTrials, numberOfSuccesses, confidenceLevel);
    }

    public static ConfidenceInterval getClopperPearsonInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        return CLOPPER_PEARSON.createInterval(numberOfTrials, numberOfSuccesses, confidenceLevel);
    }

    public static ConfidenceInterval getNormalApproximationInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        return NORMAL_APPROXIMATION.createInterval(numberOfTrials, numberOfSuccesses, confidenceLevel);
    }

    public static ConfidenceInterval getWilsonScoreInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        return WILSON_SCORE.createInterval(numberOfTrials, numberOfSuccesses, confidenceLevel);
    }

    static void checkParameters(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        if (numberOfTrials <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_TRIALS, numberOfTrials);
        }
        if (numberOfSuccesses < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, numberOfSuccesses);
        }
        if (numberOfSuccesses > numberOfTrials) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESS_LARGER_THAN_POPULATION_SIZE, (Number)numberOfSuccesses, numberOfTrials, true);
        }
        if (confidenceLevel <= 0.0 || confidenceLevel >= 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_CONFIDENCE_LEVEL, (Number)confidenceLevel, 0, 1);
        }
    }
}

