/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.RenderQuotedNames;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.SettingsTools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractName;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class UnqualifiedName
extends AbstractName {
    final String name;
    final Name.Quoted quoted;

    UnqualifiedName(String name) {
        this(name, Name.Quoted.DEFAULT);
    }

    UnqualifiedName(String name, Name.Quoted quoted) {
        this.name = name;
        this.quoted = quoted;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean previous = ctx.quote();
        ctx.quote(this.quoted(ctx));
        ctx.literal(StringUtils.defaultIfNull(this.name, ""));
        ctx.quote(previous);
    }

    final boolean quoted(Scope ctx) {
        return UnqualifiedName.quoted(SettingsTools.getRenderQuotedNames(ctx.settings()), this.quoted);
    }

    static final boolean quoted(RenderQuotedNames q, Name.Quoted quoted) {
        return quoted != Name.Quoted.SYSTEM && (q == RenderQuotedNames.ALWAYS || q == RenderQuotedNames.EXPLICIT_DEFAULT_QUOTED && (quoted == Name.Quoted.DEFAULT || quoted == Name.Quoted.QUOTED) || q == RenderQuotedNames.EXPLICIT_DEFAULT_UNQUOTED && quoted == Name.Quoted.QUOTED);
    }

    @Override
    public final String first() {
        return this.name;
    }

    @Override
    public final String last() {
        return this.name;
    }

    @Override
    public final boolean empty() {
        return StringUtils.isEmpty(this.name);
    }

    @Override
    public final boolean qualified() {
        return false;
    }

    @Override
    public final boolean qualifierQualified() {
        return false;
    }

    @Override
    public final Name qualifier() {
        return null;
    }

    @Override
    public final Name unqualifiedName() {
        return this;
    }

    @Override
    public final Name.Quoted quoted() {
        return this.quoted;
    }

    @Override
    public final Name quotedName() {
        return new UnqualifiedName(this.name, Name.Quoted.QUOTED);
    }

    @Override
    public final Name unquotedName() {
        return new UnqualifiedName(this.name, Name.Quoted.UNQUOTED);
    }

    @Override
    public final String[] getName() {
        String[] stringArray;
        if (this.empty()) {
            stringArray = Tools.EMPTY_STRING;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.name;
        }
        return stringArray;
    }

    @Override
    public final Name[] parts() {
        Name[] nameArray;
        if (this.empty()) {
            nameArray = Tools.EMPTY_NAME;
        } else {
            Name[] nameArray2 = new Name[1];
            nameArray = nameArray2;
            nameArray2[0] = this;
        }
        return nameArray;
    }

    @Override
    public int hashCode() {
        return 31 + StringUtils.defaultIfNull(this.name, "").hashCode();
    }
}

