/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DatePart;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;

final class TruncDate<T>
extends AbstractField<T>
implements QOM.UNotYetImplemented {
    private final Field<T> date;
    private final DatePart part;

    TruncDate(Field<T> date, DatePart part) {
        super(Names.N_TRUNC, date.getDataType());
        this.date = date;
        this.part = part;
    }

    @Override
    public final void accept(Context<?> ctx) {
        String keyword = null;
        String format = null;
        block0 : switch (ctx.family()) {
            case CUBRID: 
            case HSQLDB: {
                switch (this.part) {
                    case YEAR: {
                        keyword = "YY";
                        break;
                    }
                    case MONTH: {
                        keyword = "MM";
                        break;
                    }
                    case DAY: {
                        keyword = "DD";
                        break;
                    }
                    case HOUR: {
                        keyword = "HH";
                        break;
                    }
                    case MINUTE: {
                        keyword = "MI";
                        break;
                    }
                    case SECOND: {
                        keyword = "SS";
                        break;
                    }
                    default: {
                        this.acceptDefaultEmulation(ctx);
                        break block0;
                    }
                }
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
                break;
            }
            case H2: {
                switch (this.part) {
                    case YEAR: {
                        format = "yyyy";
                        break;
                    }
                    case MONTH: {
                        format = "yyyy-MM";
                        break;
                    }
                    case DAY: {
                        format = "yyyy-MM-dd";
                        break;
                    }
                    case HOUR: {
                        format = "yyyy-MM-dd HH";
                        break;
                    }
                    case MINUTE: {
                        format = "yyyy-MM-dd HH:mm";
                        break;
                    }
                    case SECOND: {
                        format = "yyyy-MM-dd HH:mm:ss";
                        break;
                    }
                    default: {
                        this.acceptDefaultEmulation(ctx);
                        break block0;
                    }
                }
                ctx.visit(DSL.keyword("parsedatetime")).sql('(').visit(DSL.keyword("formatdatetime")).sql('(').visit(this.date).sql(", ").visit(DSL.inline(format)).sql("), ").visit(DSL.inline(format)).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_DATE_TRUNC).sql('(').visit(DSL.inline(this.part.toKeyword().toString())).sql(", ").visit(this.date).sql(')');
                break;
            }
            default: {
                ctx.visit(Names.N_TRUNC).sql('(').visit(this.date).sql(", ").visit(DSL.inline(keyword)).sql(')');
            }
        }
    }

    private final void acceptDefaultEmulation(Context<?> ctx) {
        switch (this.part) {
            case DECADE: {
                ctx.visit(this.padYear(ctx, 3, DSL.extract(this.date, this.part)).concat(this.dateOrTimestampLiteral("0-01-01")).cast(this.getDataType()));
                break;
            }
            case CENTURY: {
                ctx.visit(this.padYear(ctx, 2, DSL.extract(this.date, this.part).minus(DSL.inline(1))).concat(this.dateOrTimestampLiteral("01-01-01")).cast(this.getDataType()));
                break;
            }
            case MILLENNIUM: {
                ctx.visit(DSL.extract(this.date, this.part).minus(DSL.inline(1)).cast(SQLDataType.VARCHAR(10)).concat(this.dateOrTimestampLiteral("001-01-01")).cast(this.getDataType()));
                break;
            }
            case QUARTER: {
                ctx.visit(this.padYear(ctx, 4, DSL.extract(this.date, DatePart.YEAR)).concat(DSL.inline("-")).concat(DSL.extract(this.date, this.part).minus(DSL.inline(1)).times(DSL.inline(3)).plus(DSL.inline(1)).cast(SQLDataType.VARCHAR(10))).concat(this.dateOrTimestampLiteral("-01")).cast(this.getDataType()));
                break;
            }
            default: {
                this.throwUnsupported();
            }
        }
    }

    private final Field<String> padYear(Context<?> ctx, int length, Field<Integer> year) {
        switch (ctx.family()) {
            case HSQLDB: {
                return DSL.lpad(year.cast(SQLDataType.VARCHAR(10)), DSL.inline(length), DSL.inline("0"));
            }
        }
        return year.cast(SQLDataType.VARCHAR(10));
    }

    private final Field<String> dateOrTimestampLiteral(String string) {
        return DSL.inline((String)(this.getDataType().isDate() ? string : string + " 00:00:00"));
    }

    private final void throwUnsupported() {
        throw new UnsupportedOperationException("Unknown date part : " + String.valueOf((Object)this.part));
    }
}

