/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortField;
import io.lumine.mythic.bukkit.utils.lib.jooq.SortOrder;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SimpleCheckQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class SortFieldImpl<T>
extends AbstractQueryPart
implements SortField<T>,
SimpleCheckQueryPart {
    private static final Set<SQLDialect> NO_SUPPORT_NULLS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.MARIADB, SQLDialect.MYSQL);
    final Field<T> field;
    final SortOrder order;
    QOM.NullOrdering nullOrdering;

    SortFieldImpl(Field<T> field, SortOrder order) {
        this(field, order, null);
    }

    SortFieldImpl(Field<T> field, SortOrder order, QOM.NullOrdering nullOrdering) {
        this.field = field;
        this.order = order;
        this.nullOrdering = nullOrdering;
    }

    @Override
    public boolean isSimple(Context<?> ctx) {
        return this.nullOrdering == null && Tools.isSimple(ctx, this.field);
    }

    @Override
    public final String getName() {
        return this.field.getName();
    }

    @Override
    public final SortOrder getOrder() {
        return this.order;
    }

    @Override
    public final SortField<T> nullsFirst() {
        this.nullOrdering = QOM.NullOrdering.NULLS_FIRST;
        return this;
    }

    @Override
    public final SortField<T> nullsLast() {
        this.nullOrdering = QOM.NullOrdering.NULLS_LAST;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.nullOrdering != null) {
            if (NO_SUPPORT_NULLS.contains((Object)ctx.dialect())) {
                Param<Integer> ifNull = this.nullOrdering == QOM.NullOrdering.NULLS_FIRST ? DSL.zero() : DSL.one();
                Param<Integer> ifNotNull = this.nullOrdering == QOM.NullOrdering.NULLS_FIRST ? DSL.one() : DSL.zero();
                ctx.visit(DSL.nvl2(this.field, ifNotNull, ifNull)).sql(", ");
                this.acceptFieldAndOrder(ctx, false);
            } else {
                this.acceptFieldAndOrder(ctx, true);
            }
        } else {
            this.acceptFieldAndOrder(ctx, false);
        }
    }

    private final void acceptFieldAndOrder(Context<?> ctx, boolean includeNulls) {
        String separator = "";
        for (Field<T> f : Tools.flatten(this.field)) {
            ctx.sql(separator).visit(f);
            if (this.order != SortOrder.DEFAULT) {
                ctx.sql(' ').visit(this.order.toKeyword());
            }
            if (includeNulls) {
                if (this.nullOrdering == QOM.NullOrdering.NULLS_FIRST) {
                    ctx.sql(' ').visit(Keywords.K_NULLS_FIRST);
                } else {
                    ctx.sql(' ').visit(Keywords.K_NULLS_LAST);
                }
            }
            separator = ", ";
        }
    }

    @Override
    public final Field<T> $field() {
        return this.field;
    }

    @Override
    public final <U> SortField<U> $field(Field<U> newField) {
        if (newField == this.field) {
            return this;
        }
        return new SortFieldImpl<U>(newField, this.order, this.nullOrdering);
    }

    @Override
    public final SortOrder $sortOrder() {
        return this.order;
    }

    @Override
    public final SortField<T> $sortOrder(SortOrder newOrder) {
        if (newOrder == this.order) {
            return this;
        }
        return new SortFieldImpl<T>(this.field, newOrder, this.nullOrdering);
    }

    @Override
    public final QOM.NullOrdering $nullOrdering() {
        return this.nullOrdering;
    }

    @Override
    public final SortField<T> $nullOrdering(QOM.NullOrdering newOrdering) {
        if (newOrdering == this.nullOrdering) {
            return this;
        }
        return new SortFieldImpl<T>(this.field, this.order, newOrdering);
    }
}

