/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.BindContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.QualifiedRecord;
import io.lumine.mythic.bukkit.utils.lib.jooq.RecordQualifier;
import io.lumine.mythic.bukkit.utils.lib.jooq.RenderContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.SQLDialectNotSupportedException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractParam;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Cast;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultBinding;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class QualifiedRecordConstant<R extends QualifiedRecord<R>>
extends AbstractParam<R>
implements QOM.UNotYetImplemented {
    final RecordQualifier<R> qualifier;

    QualifiedRecordConstant(R value, RecordQualifier<R> qualifier) {
        super(value, qualifier.getDataType());
        this.qualifier = qualifier;
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext ctx) {
        ParamType paramType = ctx.paramType();
        if (this.isInline()) {
            ctx.paramType(ParamType.INLINED);
        }
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.toSQLInline(ctx);
                break;
            }
            default: {
                this.toSQLInline(ctx);
            }
        }
        if (this.isInline()) {
            ctx.paramType(paramType);
        }
    }

    @Override
    final boolean isInline(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        return this.value == null || super.isInline(ctx);
    }

    private final void toSQLInline(RenderContext ctx) {
        Cast.renderCastIf(ctx, c -> {
            if (this.value == null) {
                c.visit(Keywords.K_NULL);
            } else {
                switch (c.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: 
                    case DUCKDB: {
                        c.visit(Keywords.K_ROW);
                        break;
                    }
                    default: {
                        c.visit(this.mappedQualifier(ctx));
                    }
                }
                c.sql('(');
                String separator = "";
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    c.sql(separator);
                    c.visit(DSL.val(((QualifiedRecord)this.value).get(field), field));
                    separator = ", ";
                }
                c.sql(')');
            }
        }, c -> c.visit(this.mappedQualifier(ctx)), () -> DefaultBinding.DefaultRecordBinding.REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()));
    }

    private final RecordQualifier<?> mappedQualifier(RenderContext ctx) {
        RecordQualifier<?> mapped = Tools.getMappedQualifier(ctx, this.qualifier);
        return mapped != null ? mapped : this.qualifier;
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: 
            case DUCKDB: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName((Scope)ctx, (QualifiedRecord)this.value);
    }

    final void bind0(BindContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: 
            case DUCKDB: {
                if (this.value == null) break;
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    ctx.visit(DSL.val(((QualifiedRecord)this.value).get(field), field.getDataType()));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + String.valueOf((Object)ctx.dialect()));
            }
        }
    }
}

