/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.SQLDialectNotSupportedException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldsImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;

final class MetaDataFieldProvider
implements Serializable {
    private static final JooqLogger log = JooqLogger.getLogger(MetaDataFieldProvider.class);
    private final FieldsImpl<Record> fields;

    MetaDataFieldProvider(Configuration configuration, ResultSetMetaData meta) {
        this.fields = MetaDataFieldProvider.init(configuration, meta);
    }

    private static FieldsImpl<Record> init(Configuration configuration, ResultSetMetaData meta) {
        Field[] fields;
        int columnCount = 0;
        try {
            columnCount = meta.getColumnCount();
            fields = new Field[columnCount];
        }
        catch (SQLException e) {
            log.info("Cannot fetch column count for cursor : " + e.getMessage());
            fields = new Field[]{DSL.field("dummy")};
        }
        try {
            for (int i = 1; i <= columnCount; ++i) {
                DataType<Object> dataType;
                Name name;
                block20: {
                    block19: {
                        String columnLabel = meta.getColumnLabel(i);
                        String columnName = meta.getColumnName(i);
                        if (Objects.equals(columnName, columnLabel)) {
                            try {
                                String columnSchema = meta.getSchemaName(i);
                                String columnTable = meta.getTableName(i);
                                if (!StringUtils.isEmpty(columnSchema)) {
                                    name = DSL.name(columnSchema, columnTable, columnName);
                                    break block19;
                                }
                                if (!StringUtils.isEmpty(columnTable)) {
                                    name = DSL.name(columnTable, columnName);
                                    break block19;
                                }
                                name = DSL.name(columnName);
                            }
                            catch (SQLException e) {
                                name = DSL.name(columnLabel);
                            }
                        } else {
                            name = DSL.name(columnLabel);
                        }
                    }
                    int precision = meta.getPrecision(i);
                    int scale = meta.getScale(i);
                    dataType = SQLDataType.OTHER;
                    String type = meta.getColumnTypeName(i);
                    if (type != null) {
                        try {
                            dataType = DefaultDataType.getDataType(configuration.family(), type, precision, scale, !Boolean.FALSE.equals(configuration.settings().isForceIntegerTypesOnZeroScaleDecimals()));
                            if (dataType.hasPrecision()) {
                                dataType = dataType.precision(precision);
                            }
                            if (dataType.hasScale()) {
                                dataType = dataType.scale(scale);
                            }
                            if (dataType.hasLength()) {
                                dataType = dataType.length(precision);
                            }
                            break block20;
                        }
                        catch (SQLDialectNotSupportedException e) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Not supported by dialect", e.getMessage());
                            }
                            break block20;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("No type name is available at column index: " + i);
                    }
                }
                fields[i - 1] = DSL.field(name, dataType);
            }
        }
        catch (SQLException e) {
            throw Tools.translate((Scope)configuration.dsl(), null, e);
        }
        return new FieldsImpl<Record>(fields);
    }

    final Field<?>[] getFields() {
        return this.fields.fields();
    }

    public String toString() {
        return this.fields.toString();
    }
}

