/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Meta;
import io.lumine.mythic.bukkit.utils.lib.jooq.MetaProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.Query;
import io.lumine.mythic.bukkit.utils.lib.jooq.Source;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Interpreter;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ParserException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.io.Reader;
import java.util.Scanner;

final class InterpreterMetaProvider
implements MetaProvider {
    private static final JooqLogger log = JooqLogger.getLogger(InterpreterMetaProvider.class);
    private final Configuration configuration;
    private final Source[] sources;
    private final Query[] queries;

    public InterpreterMetaProvider(Configuration configuration, Source ... sources) {
        this.configuration = Tools.configuration(configuration);
        this.sources = sources;
        this.queries = null;
    }

    public InterpreterMetaProvider(Configuration configuration, Query ... queries) {
        this.configuration = Tools.configuration(configuration);
        this.sources = null;
        this.queries = queries;
    }

    @Override
    public Meta provide() {
        Interpreter interpreter = new Interpreter(this.configuration);
        Configuration localConfiguration = this.configuration.derive();
        DSLContext ctx = DSL.using(localConfiguration);
        if (this.sources != null) {
            for (Source source : this.sources) {
                this.loadSource(ctx, source, interpreter);
            }
        } else {
            for (Query query : this.queries) {
                interpreter.accept(query);
            }
        }
        return interpreter.meta();
    }

    private final void loadSource(DSLContext ctx, Source source, Interpreter interpreter) {
        Reader reader = null;
        try {
            reader = source.reader();
            Scanner s2 = new Scanner(reader).useDelimiter("\\A");
            for (Query query : ctx.parser().parse(s2.hasNext() ? s2.next() : "")) {
                interpreter.accept(query);
            }
        }
        catch (ParserException e) {
            try {
                log.error((Object)("An exception occurred while parsing a DDL script: " + e.getMessage() + ". Please report this error to https://jooq.org/bug"), e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtils.safeClose(reader);
                throw throwable;
            }
        }
        JDBCUtils.safeClose(reader);
    }
}

