/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.AlterSequenceFlagsStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.AlterSequenceStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Check;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DDLExportConfiguration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Domain;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.ForeignKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.Index;
import io.lumine.mythic.bukkit.utils.lib.jooq.Meta;
import io.lumine.mythic.bukkit.utils.lib.jooq.MigrationConfiguration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Named;
import io.lumine.mythic.bukkit.utils.lib.jooq.Nullability;
import io.lumine.mythic.bukkit.utils.lib.jooq.Queries;
import io.lumine.mythic.bukkit.utils.lib.jooq.Query;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.Sequence;
import io.lumine.mythic.bukkit.utils.lib.jooq.Table;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableOptions;
import io.lumine.mythic.bukkit.utils.lib.jooq.UniqueKey;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AlterTableImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Comparators;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ConstraintType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Convert;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.CreateTableImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.HistoryImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Val;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;

final class Diff
extends AbstractScope {
    private static final Set<SQLDialect> NO_SUPPORT_PK_NAMES = SQLDialect.supportedBy(SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final MigrationConfiguration migrateConf;
    private final DDLExportConfiguration exportConf;
    private final DSLContext ctx;
    private final Meta meta1;
    private final Meta meta2;
    private final DDL ddl;
    private final DependencyComparator comparator;
    private final Merge<Table<?>> MERGE_TABLE = new Merge<Table<?>>(){

        @Override
        public void merge(DiffResult r, Table<?> t1, Table<?> t2) {
            String c2;
            String c1;
            boolean v2;
            boolean m1 = t1.getTableType() == TableOptions.TableType.MATERIALIZED_VIEW;
            boolean m22 = t2.getTableType() == TableOptions.TableType.MATERIALIZED_VIEW;
            boolean v1 = t1.getTableType() == TableOptions.TableType.VIEW;
            boolean bl = v2 = t2.getTableType() == TableOptions.TableType.VIEW;
            if (v1 && v2 || m1 && m22) {
                if (!Arrays.equals(t1.fields(), t2.fields()) || t2.getOptions().select() != null && !t2.getOptions().select().equals(t1.getOptions().select()) || t2.getOptions().source() != null && !t2.getOptions().source().equals(t1.getOptions().source())) {
                    this.replaceView(r, t1, t2, true);
                    return;
                }
            } else {
                if (v1 != v2 || m1 != m22) {
                    this.replaceView(r, t1, t2, false);
                    return;
                }
                DiffResult temp = new DiffResult(new ArrayList<Query>(), new ArrayList<Query>(), r.addedFks, r.droppedFks);
                Diff.this.appendColumns(temp, t1, t2, Arrays.asList(t1.fields()), Arrays.asList(t2.fields()));
                Diff.this.appendPrimaryKey(temp, t1, Arrays.asList(t1.getPrimaryKey()), Arrays.asList(t2.getPrimaryKey()));
                Diff.this.appendUniqueKeys(temp, t1, Diff.this.removePrimary(t1.getKeys()), Diff.this.removePrimary(t2.getKeys()));
                Diff.this.appendForeignKeys(temp, t1, t1.getReferences(), t2.getReferences());
                Diff.this.appendChecks(temp, t1, t1.getChecks(), t2.getChecks());
                Diff.this.appendIndexes(temp, t1, t1.getIndexes(), t2.getIndexes());
                temp.queries.sort(Diff.this.comparator);
                r.addAll(temp);
            }
            if (!(c1 = StringUtils.defaultString(t1.getComment())).equals(c2 = StringUtils.defaultString(t2.getComment()))) {
                if (v2) {
                    r.queries.add(Diff.this.ctx.commentOnView(t2).is(c2));
                } else if (m22) {
                    r.queries.add(Diff.this.ctx.commentOnMaterializedView(t2).is(c2));
                } else {
                    r.queries.add(Diff.this.ctx.commentOnTable(t2).is(c2));
                }
            }
        }

        private void replaceView(DiffResult r, Table<?> v1, Table<?> v2, boolean canReplace) {
            if (!canReplace || v2.getTableType() == TableOptions.TableType.VIEW && !Diff.this.migrateConf.createOrReplaceView() || v2.getTableType() == TableOptions.TableType.MATERIALIZED_VIEW && !Diff.this.migrateConf.createOrReplaceMaterializedView()) {
                Diff.this.dropTable().drop(r, v1);
            }
            Diff.this.createTable().create(r, v2);
        }
    };

    Diff(Configuration configuration, MigrationConfiguration migrateConf, Meta meta1, Meta meta2) {
        super(HistoryImpl.initCtx(configuration, configuration.settings().getMigrationDefaultSchema()));
        this.migrateConf = migrateConf;
        this.exportConf = new DDLExportConfiguration().createOrReplaceView(migrateConf.createOrReplaceView()).createOrReplaceMaterializedView(migrateConf.createOrReplaceMaterializedView());
        this.ctx = this.dsl();
        this.meta1 = meta1;
        this.meta2 = meta2;
        this.ddl = new DDL(this.ctx, this.exportConf);
        this.comparator = new DependencyComparator();
    }

    final Queries queries() {
        return this.ctx.queries(this.patch((DiffResult)this.appendCatalogs((DiffResult)new DiffResult(), this.meta1.getCatalogs(), this.meta2.getCatalogs())).queries);
    }

    private final DiffResult patch(DiffResult result) {
        if (Tools.anyMatch(result.queries, q -> this.droppingPKorUK((Query)q)) && Tools.anyMatch(result.queries, q -> q instanceof QOM.DropTable)) {
            List fks = Tools.flatMap(Tools.filter(result.queries, q -> q instanceof QOM.DropTable), q -> ((QOM.DropTable)q).$table().getReferences());
            HashSet<UniqueKey> uks = new HashSet<UniqueKey>(Tools.map(Tools.filter(result.queries, q -> this.droppingPKorUK((Query)q)), q -> this.droppedPKorUK((AlterTableImpl)q)));
            boolean sort = false;
            for (ForeignKey x : Tools.filter(fks, fk -> uks.contains(fk.getKey()) && !result.droppedFks.contains(fk))) {
                result.queries.add(this.ctx.alterTable(x.getTable()).dropForeignKey(x.constraint()));
                sort = true;
            }
            if (sort) {
                result.queries.sort(this.comparator);
            }
        }
        return result;
    }

    private final boolean droppingPKorUK(Query q) {
        if (q instanceof AlterTableImpl) {
            AlterTableImpl a = (AlterTableImpl)q;
            if (a.$dropConstraintType() == ConstraintType.PRIMARY_KEY) {
                return true;
            }
            if (a.$dropConstraintType() == ConstraintType.UNIQUE) {
                return true;
            }
            return this.droppedPKorUK(a) != null;
        }
        return false;
    }

    private final UniqueKey<?> droppedPKorUK(AlterTableImpl a) {
        if (a.$dropConstraintType() == ConstraintType.PRIMARY_KEY) {
            return a.$table().getPrimaryKey();
        }
        return Tools.findAny(a.$table().getUniqueKeys(), u -> u.constraint().equals(a.$dropConstraint()));
    }

    private final DiffResult appendCatalogs(DiffResult result, List<Catalog> l1, List<Catalog> l2) {
        return this.append(result, l1, l2, null, null, null, (r, c1, c2) -> this.appendSchemas(r, c1.getSchemas(), c2.getSchemas()));
    }

    private final DiffResult appendSchemas(DiffResult result, List<Schema> l1, List<Schema> l2) {
        return this.append(result, l1, l2, null, (r, s2) -> r.queries.addAll(Arrays.asList(this.ctx.ddl((Schema)s2).queries())), (r, s2) -> {
            if (s2.getTables().isEmpty() && s2.getSequences().isEmpty()) {
                if (!StringUtils.isEmpty(s2.getName())) {
                    r.queries.add(this.ctx.dropSchema((Schema)s2));
                }
            } else if (this.migrateConf.dropSchemaCascade()) {
                for (Table<?> table : s2.getTables()) {
                    for (UniqueKey<?> uk : table.getKeys()) {
                        r.droppedFks.addAll(uk.getReferences());
                    }
                }
                if (!StringUtils.isEmpty(s2.getName())) {
                    r.queries.add(this.ctx.dropSchema((Schema)s2).cascade());
                }
            } else {
                for (Table<?> table : s2.getTables()) {
                    this.dropTable().drop(r, table);
                }
                for (Sequence sequence : s2.getSequences()) {
                    this.dropSequence().drop(r, sequence);
                }
                if (!StringUtils.isEmpty(s2.getName())) {
                    r.queries.add(this.ctx.dropSchema((Schema)s2));
                }
            }
        }, (r, s1, s2) -> {
            this.appendDomains(r, s1.getDomains(), s2.getDomains());
            this.appendTables(r, s1.getTables(), s2.getTables());
            this.appendSequences(r, s1.getSequences(), s2.getSequences());
        });
    }

    private final Drop<Sequence<?>> dropSequence() {
        return (r, s2) -> r.queries.add(this.ctx.dropSequence((Sequence<?>)s2));
    }

    private final DiffResult appendSequences(DiffResult result, List<? extends Sequence<?>> l1, List<? extends Sequence<?>> l2) {
        return this.append(result, l1, l2, null, (r, s2) -> r.queries.add(this.ddl.createSequence((Sequence<?>)s2)), this.dropSequence(), (r, s1, s2) -> {
            AlterSequenceFlagsStep<Object> stmt = null;
            AlterSequenceStep stmt0 = this.ctx.alterSequence(s1);
            if (s2.getStartWith() != null && !this.equivalentSequenceFlag((Sequence<?>)s2, (Sequence<?>)s1, Sequence::getStartWith, this::defaultStartWithValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).startWith(s2.getStartWith());
            } else if (s2.getStartWith() == null && s1.getStartWith() != null && !this.equivalentSequenceFlag((Sequence<?>)s1, (Sequence<?>)s2, Sequence::getStartWith, this::defaultStartWithValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).startWith(this.defaultStartWithValue((Sequence<?>)s2));
            }
            if (s2.getIncrementBy() != null && !this.equivalentSequenceFlag((Sequence<?>)s2, (Sequence<?>)s1, Sequence::getIncrementBy, this::defaultIncrementByValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).incrementBy(s2.getIncrementBy());
            } else if (s2.getIncrementBy() == null && s1.getIncrementBy() != null && !this.equivalentSequenceFlag((Sequence<?>)s1, (Sequence<?>)s2, Sequence::getIncrementBy, this::defaultIncrementByValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).incrementBy(this.defaultIncrementByValue((Sequence<?>)s2));
            }
            if (s2.getMinvalue() != null && !this.equivalentSequenceFlag((Sequence<?>)s2, (Sequence<?>)s1, Sequence::getMinvalue, this::defaultMinValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).minvalue(s2.getMinvalue());
            } else if (s2.getMinvalue() == null && s1.getMinvalue() != null && !this.equivalentSequenceFlag((Sequence<?>)s1, (Sequence<?>)s2, Sequence::getMinvalue, this::defaultMinValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noMinvalue();
            }
            if (s2.getMaxvalue() != null && !this.equivalentSequenceFlag((Sequence<?>)s2, (Sequence<?>)s1, Sequence::getMaxvalue, this::defaultMaxValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).maxvalue(s2.getMaxvalue());
            } else if (s2.getMaxvalue() == null && s1.getMaxvalue() != null && !this.equivalentSequenceFlag((Sequence<?>)s1, (Sequence<?>)s2, Sequence::getMaxvalue, this::defaultMaxValue)) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noMaxvalue();
            }
            if (s2.getCache() != null && !s2.getCache().equals(s1.getCache())) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).cache(s2.getCache());
            } else if (s2.getCache() == null && s1.getCache() != null) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noCache();
            }
            if (s2.getCycle() && !s1.getCycle()) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).cycle();
            } else if (!s2.getCycle() && s1.getCycle()) {
                stmt = ((AlterSequenceFlagsStep)StringUtils.defaultIfNull(stmt, stmt0)).noCycle();
            }
            if (stmt != null) {
                r.queries.add(stmt);
            }
        });
    }

    private final boolean equivalentSequenceFlag(Sequence<?> s2, Sequence<?> s1, Function<? super Sequence<?>, ? extends Field<?>> flag, ToLongFunction<? super Sequence<?>> defaultValue) {
        Field<?> sw1;
        Field<?> sw2 = flag.apply(s2);
        if (Objects.equals(sw2, sw1 = flag.apply(s1))) {
            return true;
        }
        return this.equivalentSequenceFlagValue(sw2, sw1, defaultValue.applyAsLong(s2)) || this.equivalentSequenceFlagValue(sw1, sw2, defaultValue.applyAsLong(s1));
    }

    private final boolean equivalentSequenceFlagValue(Field<?> sw2, Field<?> sw1, Long defaultValue) {
        return sw1 == null && Tools.isVal1(sw2, v -> Objects.equals(Convert.convert(v.getValue(), Long.class), defaultValue));
    }

    private final Long defaultStartWithValue(Sequence<?> s2) {
        switch (this.ctx.family()) {
            case HSQLDB: {
                return 0L;
            }
        }
        return 1L;
    }

    private final Long defaultIncrementByValue(Sequence<?> s2) {
        return 1L;
    }

    private final Long defaultMinValue(Sequence<?> s2) {
        if (s2.getDataType().getFromType() == Byte.class) {
            return -128L;
        }
        if (s2.getDataType().getFromType() == Short.class) {
            return -32768L;
        }
        if (s2.getDataType().getFromType() == Integer.class) {
            return Integer.MIN_VALUE;
        }
        if (s2.getDataType().getFromType() == Long.class) {
            return Long.MIN_VALUE;
        }
        return null;
    }

    private final Long defaultMaxValue(Sequence<?> s2) {
        if (s2.getDataType().getFromType() == Byte.class) {
            return 127L;
        }
        if (s2.getDataType().getFromType() == Short.class) {
            return 32767L;
        }
        if (s2.getDataType().getFromType() == Integer.class) {
            return Integer.MAX_VALUE;
        }
        if (s2.getDataType().getFromType() == Long.class) {
            return Long.MAX_VALUE;
        }
        return null;
    }

    private final DiffResult appendDomains(DiffResult result, List<? extends Domain<?>> l1, List<? extends Domain<?>> l2) {
        return this.append(result, l1, l2, null, (r, d) -> r.queries.add(this.ddl.createDomain((Domain<?>)d)), (r, d) -> r.queries.add(this.ctx.dropDomain((Domain<?>)d)), (r, d1, d2) -> {
            if (!d1.getDataType().getSQLDataType().equals(d2.getDataType().getSQLDataType())) {
                r.queries.addAll(Arrays.asList(this.ctx.dropDomain((Domain<?>)d1), this.ddl.createDomain((Domain<?>)d2)));
            } else {
                if (d1.getDataType().defaulted() && !d2.getDataType().defaulted()) {
                    r.queries.add(this.ctx.alterDomain(d1).dropDefault());
                } else if (d2.getDataType().defaulted() && !d2.getDataType().defaultValue().equals(d1.getDataType().defaultValue())) {
                    r.queries.add(this.ctx.alterDomain(d1).setDefault(d2.getDataType().defaultValue()));
                }
                this.appendChecks(r, (Domain<?>)d1, (List<? extends Check<?>>)d1.getChecks(), (List<? extends Check<?>>)d2.getChecks());
            }
        });
    }

    private final Create<Table<?>> createTable() {
        return (r, t2) -> r.queries.addAll(Arrays.asList(this.ddl.queries((Table<?>)t2).queries()));
    }

    private final Drop<Table<?>> dropTable() {
        return (r, t2) -> {
            for (UniqueKey uk : t2.getKeys()) {
                for (ForeignKey fk : uk.getReferences()) {
                    if (!r.droppedFks.add(fk) || this.migrateConf.dropTableCascade()) continue;
                    r.queries.add(this.ctx.alterTable(fk.getTable()).dropForeignKey(fk.constraint()));
                }
            }
            if (t2.getTableType() == TableOptions.TableType.VIEW) {
                r.queries.add(this.ctx.dropView((Table<?>)t2));
            } else if (t2.getTableType() == TableOptions.TableType.MATERIALIZED_VIEW) {
                r.queries.add(this.ctx.dropMaterializedView((Table<?>)t2));
            } else if (t2.getTableType() == TableOptions.TableType.TEMPORARY) {
                r.queries.add(this.ctx.dropTemporaryTable((Table<?>)t2));
            } else {
                r.queries.add(this.migrateConf.dropTableCascade() ? this.ctx.dropTable((Table<?>)t2).cascade() : this.ctx.dropTable((Table<?>)t2));
            }
        };
    }

    private final DiffResult appendTables(DiffResult result, List<? extends Table<?>> l1, List<? extends Table<?>> l2) {
        return this.append(result, l1, l2, null, this.createTable(), this.dropTable(), this.MERGE_TABLE);
    }

    private final List<UniqueKey<?>> removePrimary(List<? extends UniqueKey<?>> list) {
        ArrayList result = new ArrayList();
        for (UniqueKey<?> uk : list) {
            if (uk.isPrimary()) continue;
            result.add(uk);
        }
        return result;
    }

    private final boolean isSynthetic(Field<?> f) {
        switch (this.ctx.family()) {
            // Empty switch
        }
        return false;
    }

    private final boolean isSynthetic(UniqueKey<?> pk) {
        switch (this.ctx.family()) {
            // Empty switch
        }
        return false;
    }

    private final DiffResult appendColumns(DiffResult result, final Table<?> t1, final Table<?> t2, List<? extends Field<?>> l1, List<? extends Field<?>> l2) {
        ArrayList add = new ArrayList();
        ArrayList drop = new ArrayList();
        result = this.append(result, l1, l2, Comparators.UNQUALIFIED_COMP, (r, f) -> {
            if (!this.isSynthetic((Field<?>)f)) {
                if (this.migrateConf.alterTableAddMultiple()) {
                    add.add(f);
                } else {
                    r.queries.add(this.ctx.alterTable(t1).add((Field<?>)f));
                }
            }
        }, (r, f) -> {
            if (!this.isSynthetic((Field<?>)f)) {
                if (this.migrateConf.alterTableDropMultiple()) {
                    drop.add(f);
                } else {
                    r.queries.add(this.ctx.alterTable(t1).drop((Field<?>)f));
                }
            }
        }, new Merge<Field<?>>(){

            @Override
            public void merge(DiffResult r, Field<?> f1, Field<?> f2) {
                DataType type2;
                DataType type1 = f1.getDataType();
                if (this.typeNameDifference(type1, type2 = f2.getDataType())) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).set(type2.nullability(Nullability.DEFAULT)));
                }
                if (type1.nullable() && !type2.nullable() && this.respectPkNullability(f1, f2)) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).setNotNull());
                } else if (!type1.nullable() && type2.nullable() && this.respectPkNullability(f1, f2)) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).dropNotNull());
                }
                Field d1 = type1.defaultValue();
                Field d2 = type2.defaultValue();
                if (type1.defaulted() && !type2.defaulted()) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).dropDefault());
                } else if (!(!type2.defaulted() || type1.defaulted() && this.equivalent(d2, d1))) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).setDefault(d2));
                }
                if (type1.hasLength() && type2.hasLength() && (type1.lengthDefined() != type2.lengthDefined() || type1.length() != type2.length()) || type1.hasPrecision() && type2.hasPrecision() && this.precisionDifference(type1, type2) || type1.hasScale() && type2.hasScale() && (type1.scaleDefined() != type2.scaleDefined() || type1.scale() != type2.scale())) {
                    r.queries.add(Diff.this.ctx.alterTable(t1).alter(f1).set(type2));
                }
            }

            private final boolean equivalent(Field<?> d2, Field<?> d1) {
                if (d2.equals(d1)) {
                    return true;
                }
                if (Objects.equals(d2.getDataType().getSQLDataType(), d1.getDataType().getSQLDataType())) {
                    QOM.Cast c;
                    if (d2 instanceof QOM.Cast) {
                        c = (QOM.Cast)d2;
                        d2 = c.$field();
                    }
                    if (d1 instanceof QOM.Cast) {
                        c = (QOM.Cast)d1;
                        d1 = c.$field();
                    }
                    Val<?> v2 = Tools.extractVal(d2);
                    Val<?> v1 = Tools.extractVal(d1);
                    if (v2 != null && v1 != null) {
                        return Objects.equals(v2.getValue(), v1.getValue());
                    }
                }
                return false;
            }

            private final boolean respectPkNullability(Field<?> f1, Field<?> f2) {
                if (Boolean.FALSE.equals(Diff.this.ctx.settings().isMigrationIgnoreImplicitPrimaryKeyNotNullConstraints()) || CreateTableImpl.SUPPORT_NULLABLE_PRIMARY_KEY.contains((Object)Diff.this.ctx.dialect())) {
                    return true;
                }
                UniqueKey pk1 = t1.getPrimaryKey();
                UniqueKey pk2 = t2.getPrimaryKey();
                return pk1 == null || pk2 == null || !pk1.getFields().contains(f1) || !pk2.getFields().contains(f2);
            }

            private final boolean typeNameDifference(DataType<?> type1, DataType<?> type2) {
                if (type1.getTypeName().equals(type2.getTypeName())) {
                    return false;
                }
                return type1.getType() != BigDecimal.class || type2.getType() != BigDecimal.class;
            }

            private final boolean precisionDifference(DataType<?> type1, DataType<?> type2) {
                boolean d1 = this.defaultPrecision(type1);
                boolean d2 = this.defaultPrecision(type2);
                if (d1 || d2) {
                    return d1 != d2;
                }
                return type1.precision() != type2.precision();
            }

            private final boolean defaultPrecision(DataType<?> type) {
                if (!type.isDateTime()) {
                    return false;
                }
                if (!type.precisionDefined()) {
                    return true;
                }
                if ((type.isTime() || type.isTimeWithTimeZone()) && Tools.NO_SUPPORT_TIME_PRECISION.contains((Object)Diff.this.ctx.dialect())) {
                    return true;
                }
                if (!type.isTime() && !type.isTimeWithTimeZone() && Tools.NO_SUPPORT_TIMESTAMP_PRECISION.contains((Object)Diff.this.ctx.dialect())) {
                    return true;
                }
                if (Boolean.FALSE.equals(Diff.this.ctx.settings().isMigrationIgnoreDefaultTimestampPrecisionDiffs())) {
                    return false;
                }
                switch (Diff.this.ctx.family()) {
                    case MARIADB: {
                        return type.precision() == 0;
                    }
                }
                return type.precision() == 6;
            }
        });
        if (!drop.isEmpty()) {
            result.queries.add(0, this.ctx.alterTable(t1).drop(drop));
        }
        if (!add.isEmpty()) {
            result.queries.add(this.ctx.alterTable(t1).add(add));
        }
        return result;
    }

    private final DiffResult appendPrimaryKey(DiffResult result, Table<?> t1, List<? extends UniqueKey<?>> pk1, List<? extends UniqueKey<?>> pk2) {
        Create<UniqueKey> create = (r, pk) -> {
            if (!this.isSynthetic((UniqueKey<?>)pk)) {
                r.queries.add(this.ctx.alterTable(t1).add(pk.constraint()));
            }
        };
        Drop<UniqueKey> drop = (r, pk) -> {
            if (!this.isSynthetic((UniqueKey<?>)pk)) {
                if (StringUtils.isEmpty(pk.getName())) {
                    r.queries.add(this.ctx.alterTable(t1).dropPrimaryKey());
                } else {
                    r.queries.add(this.ctx.alterTable(t1).dropPrimaryKey(pk.constraint()));
                }
            }
        };
        return this.append(result, pk1, pk2, Comparators.KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.PRIMARY_KEY), true);
    }

    private final DiffResult appendUniqueKeys(DiffResult result, Table<?> t1, List<? extends UniqueKey<?>> uk1, List<? extends UniqueKey<?>> uk2) {
        Create<UniqueKey> create = (r, u) -> r.queries.add(this.ctx.alterTable(t1).add(u.constraint()));
        Drop<UniqueKey> drop = (r, u) -> r.queries.add(this.ctx.alterTable(t1).dropUnique(u.constraint()));
        return this.append(result, uk1, uk2, Comparators.KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.UNIQUE), true);
    }

    private final <K extends Named> Merge<K> keyMerge(Table<?> t1, Create<K> create, Drop<K> drop, ConstraintType type) {
        return (r, k1, k2) -> {
            Name n1 = k1.getUnqualifiedName();
            Name n2 = k2.getUnqualifiedName();
            boolean allowRenames = true;
            if (n1.empty() ^ n2.empty()) {
                if (!Boolean.TRUE.equals(this.ctx.settings().isMigrationIgnoreUnnamedConstraintDiffs())) {
                    drop.drop(r, k1);
                    create.create(r, k2);
                    return;
                }
                allowRenames = false;
            }
            if (allowRenames && Comparators.UNQUALIFIED_COMP.compare(k1, k2) != 0 && (type != ConstraintType.PRIMARY_KEY || !NO_SUPPORT_PK_NAMES.contains((Object)this.ctx.dialect()))) {
                this.rename(r, type == ConstraintType.CHECK ? t1.getChecks() : t1.getKeys(), n1, n2, (_n1, _n2) -> this.ctx.alterTable(t1).renameConstraint((Name)_n1).to((Name)_n2));
            }
        };
    }

    private final void rename(DiffResult r, List<? extends Named> existing, Name n1, Name n2, Function2<? super Name, ? super Name, ? extends Query> renameQuery) {
        if (Tools.anyMatch(existing, k -> k.getName().equals(n2.last()))) {
            Name temp = DSL.unquotedName(Tools.autoAlias(this.ctx.configuration(), n1.append(n2)));
            if (n1.qualified()) {
                temp = n1.qualifier().append(temp);
            }
            r.queries.add(renameQuery.apply(n1, temp));
            r.cleanup.add(renameQuery.apply(temp, n2));
        } else {
            r.queries.add(renameQuery.apply(n1, n2));
        }
    }

    private final <K extends Named> Merge<K> keyMerge(Domain<?> d1, Create<K> create, Drop<K> drop) {
        return (r, k1, k2) -> {
            Name n1 = k1.getUnqualifiedName();
            Name n2 = k2.getUnqualifiedName();
            if (n1.empty() ^ n2.empty()) {
                drop.drop(r, k1);
                create.create(r, k2);
                return;
            }
            if (Comparators.UNQUALIFIED_COMP.compare(k1, k2) != 0) {
                r.queries.add(this.ctx.alterDomain(d1).renameConstraint(n1).to(n2));
            }
        };
    }

    private final DiffResult appendForeignKeys(DiffResult result, Table<?> t1, List<? extends ForeignKey<?, ?>> fk1, List<? extends ForeignKey<?, ?>> fk2) {
        Create<ForeignKey> create = (r, fk) -> {
            if (r.addedFks.add((ForeignKey<?, ?>)fk)) {
                r.queries.add(this.ctx.alterTable(t1).add(fk.constraint()));
            }
        };
        Drop<ForeignKey> drop = (r, fk) -> {
            if (r.droppedFks.add((ForeignKey<?, ?>)fk)) {
                r.queries.add(this.ctx.alterTable(t1).dropForeignKey(fk.constraint()));
            }
        };
        return this.append(result, fk1, fk2, Comparators.FOREIGN_KEY_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.FOREIGN_KEY), true);
    }

    private final DiffResult appendChecks(DiffResult result, Table<?> t1, List<? extends Check<?>> c1, List<? extends Check<?>> c2) {
        Create<Check> create = (r, c) -> r.queries.add(this.ctx.alterTable(t1).add(c.constraint()));
        Drop<Check> drop = (r, c) -> r.queries.add(this.ctx.alterTable(t1).drop(c.constraint()));
        return this.append(result, c1, c2, Comparators.CHECK_COMP, create, drop, this.keyMerge(t1, create, drop, ConstraintType.CHECK), true);
    }

    private final DiffResult appendChecks(DiffResult result, Domain<?> d1, List<? extends Check<?>> c1, List<? extends Check<?>> c2) {
        Create<Check> create = (r, c) -> r.queries.add(this.ctx.alterDomain(d1).add(c.constraint()));
        Drop<Check> drop = (r, c) -> r.queries.add(this.ctx.alterDomain(d1).dropConstraint(c.constraint()));
        return this.append(result, c1, c2, Comparators.CHECK_COMP, create, drop, this.keyMerge(d1, create, drop), true);
    }

    private final DiffResult appendIndexes(DiffResult result, Table<?> t1, List<? extends Index> l1, List<? extends Index> l2) {
        Create<Index> create = (r, i) -> r.queries.add((i.getUnique() ? this.ctx.createUniqueIndex((Index)i) : this.ctx.createIndex((Index)i)).on(t1, i.getFields()));
        Drop<Index> drop = (r, i) -> r.queries.add(this.ctx.dropIndex((Index)i).on(t1));
        return this.append(result, l1, l2, Comparators.INDEX_COMP, create, drop, (r, ix1, ix2) -> {
            if (Comparators.INDEX_COMP.compare((Index)ix1, (Index)ix2) != 0) {
                drop.drop(r, (Index)ix1);
                create.create(r, (Index)ix2);
            } else if (Comparators.UNQUALIFIED_COMP.compare(ix1, ix2) != 0) {
                this.rename(r, t1.getIndexes(), ix1.getUnqualifiedName(), ix2.getUnqualifiedName(), (_i1, _i2) -> this.ctx.alterTable(t1).renameIndex((Name)_i1).to((Name)_i2));
            }
        }, true);
    }

    private final <N extends Named> DiffResult append(DiffResult result, List<? extends N> l1, List<? extends N> l2, Comparator<? super N> comp, Create<N> create, Drop<N> drop, Merge<N> merge) {
        return this.append(result, l1, l2, comp, create, drop, merge, false);
    }

    private final <N extends Named> DiffResult append(DiffResult result, List<? extends N> l1, List<? extends N> l2, Comparator<? super N> comp, Create<N> create, Drop<N> drop, Merge<N> merge, boolean dropMergeCreate) {
        DiffResult created;
        if (comp == null) {
            comp = Comparators.NAMED_COMP;
        }
        Named s1 = null;
        Named s2 = null;
        Iterator<N> i1 = Diff.sorted(l1, comp);
        Iterator<N> i2 = Diff.sorted(l2, comp);
        DiffResult dropped = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), new ArrayList<Query>(), result.addedFks, result.droppedFks) : result;
        DiffResult merged = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), new ArrayList<Query>(), result.addedFks, result.droppedFks) : result;
        DiffResult diffResult = created = dropMergeCreate ? new DiffResult(new ArrayList<Query>(), new ArrayList<Query>(), result.addedFks, result.droppedFks) : result;
        while (true) {
            int c;
            if (s1 == null && i1.hasNext()) {
                s1 = (Named)i1.next();
            }
            if (s2 == null && i2.hasNext()) {
                s2 = (Named)i2.next();
            }
            if (s1 == null && s2 == null) break;
            int n = s1 == null ? 1 : (c = s2 == null ? -1 : comp.compare(s1, s2));
            if (c < 0) {
                if (drop != null) {
                    drop.drop(dropped, s1);
                }
                s1 = null;
                continue;
            }
            if (c > 0) {
                if (create != null) {
                    create.create(created, s2);
                }
                s2 = null;
                continue;
            }
            if (merge != null) {
                merge.merge(merged, s1, s2);
            }
            s2 = null;
            s1 = null;
        }
        if (dropMergeCreate) {
            result.addAll(dropped);
            result.addAll(merged);
            result.addAll(created);
        }
        result.queries.sort(this.comparator);
        return result;
    }

    private static final <N extends Named> Iterator<N> sorted(List<N> list, Comparator<? super N> comp) {
        ArrayList<N> result = new ArrayList<N>(list);
        result.sort(comp);
        return result.iterator();
    }

    static final int sortIndex(Query q) {
        int CATALOG = 10;
        int SCHEMA = 9;
        int SEQ = 8;
        int SYN = 7;
        int COMM = 6;
        int VIEW = 5;
        int FKEY = 4;
        int CONS = 3;
        int NULL2 = 2;
        boolean COL = true;
        if (q instanceof AlterTableImpl) {
            AlterTableImpl a = (AlterTableImpl)q;
            return a.$dropConstraint() instanceof QOM.ForeignKey || a.$dropConstraintType() == ConstraintType.FOREIGN_KEY ? -4 : (a.$addConstraint() instanceof QOM.ForeignKey || a.$dropConstraintType() == ConstraintType.FOREIGN_KEY ? 4 : (a.$dropConstraint() != null || a.$dropConstraintType() != null ? -3 : (a.$addConstraint() != null ? 3 : (a.$alterColumnNullability() == Nullability.NULL ? -2 : (a.$alterColumnNullability() == Nullability.NOT_NULL ? 2 : (a.$addColumn() != null || Tools.anyMatch(a.$add(), c -> c instanceof Field) ? -1 : (!Tools.isEmpty(a.$dropColumns()) ? 1 : 0)))))));
        }
        if (q instanceof QOM.DropDatabase) {
            return 10;
        }
        if (q instanceof QOM.CreateDatabase) {
            return -10;
        }
        if (q instanceof QOM.DropSchema) {
            return 9;
        }
        if (q instanceof QOM.CreateSchema) {
            return -9;
        }
        if (q instanceof QOM.DropSequence) {
            return 8;
        }
        if (q instanceof QOM.CreateSequence) {
            return -8;
        }
        if (q instanceof QOM.DropIndex) {
            return -3;
        }
        if (q instanceof QOM.CreateIndex) {
            return 3;
        }
        if (q instanceof QOM.DropView) {
            return -5;
        }
        if (q instanceof QOM.CreateView) {
            return 5;
        }
        if (q instanceof QOM.CommentOn) {
            return 6;
        }
        return 0;
    }

    private static interface Merge<N extends Named> {
        public void merge(DiffResult var1, N var2, N var3);
    }

    static final class DependencyComparator
    implements Comparator<Query> {
        Map<Table<?>, Set<Table<?>>> dependencies = new HashMap();

        DependencyComparator() {
        }

        @Override
        public int compare(Query q1, Query q2) {
            int i = Diff.sortIndex(q1) - Diff.sortIndex(q2);
            if (i != 0) {
                return i;
            }
            return 0;
        }
    }

    private record DiffResult(List<Query> queries, List<Query> cleanup, Set<ForeignKey<?, ?>> addedFks, Set<ForeignKey<?, ?>> droppedFks) {
        DiffResult() {
            this(new ArrayList<Query>(), new ArrayList<Query>(), new HashSet(), new HashSet());
        }

        void addAll(DiffResult other) {
            this.queries.addAll(other.queries);
            this.queries.addAll(other.cleanup);
            this.addedFks.addAll(other.addedFks);
            this.droppedFks.addAll(other.droppedFks);
        }

        @Override
        public String toString() {
            return Tools.concat(this.queries, this.cleanup).toString();
        }
    }

    private static interface Create<N extends Named> {
        public void create(DiffResult var1, N var2);
    }

    private static interface Drop<N extends Named> {
        public void drop(DiffResult var1, N var2);
    }
}

