/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.CacheContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.CacheProvider;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.LRUCache;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.util.Collections;
import java.util.Map;

final class DefaultCacheProvider
implements CacheProvider {
    DefaultCacheProvider() {
    }

    @Override
    public Map<Object, Object> provide(CacheContext ctx) {
        switch (ctx.cacheType()) {
            case CACHE_PARSING_CONNECTION: {
                return Collections.synchronizedMap(new LRUCache(StringUtils.defaultIfNull(ctx.settings().getCacheParsingConnectionLRUCacheSize(), 8192)));
            }
            case CACHE_RECORD_MAPPERS: {
                return Collections.synchronizedMap(new LRUCache(StringUtils.defaultIfNull(ctx.settings().getCacheRecordMappersLRUCacheSize(), 8192)));
            }
            case REFLECTION_CACHE_GET_ANNOTATED_GETTER: 
            case REFLECTION_CACHE_GET_ANNOTATED_MEMBERS: 
            case REFLECTION_CACHE_GET_ANNOTATED_SETTERS: 
            case REFLECTION_CACHE_GET_MATCHING_GETTER: 
            case REFLECTION_CACHE_GET_MATCHING_MEMBERS: 
            case REFLECTION_CACHE_GET_MATCHING_SETTERS: 
            case REFLECTION_CACHE_HAS_COLUMN_ANNOTATIONS: {
                return Collections.synchronizedMap(new LRUCache(StringUtils.defaultIfNull(ctx.settings().getReflectionCacheLRUCacheSize(), 32768)));
            }
        }
        return Collections.synchronizedMap(new LRUCache(8192));
    }
}

