/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.CreateSchemaFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class CreateSchemaImpl
extends AbstractDDLQuery
implements QOM.CreateSchema,
CreateSchemaFinalStep {
    final Schema schema;
    final boolean ifNotExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CREATE_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_SCHEMA_AS_DATABASE = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);

    CreateSchemaImpl(Configuration configuration, Schema schema, boolean ifNotExists) {
        super(configuration);
        this.schema = schema;
        this.ifNotExists = ifNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private final void accept0(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_SCHEMA, c -> this.accept1((Context<?>)c));
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        this.accept2(ctx);
    }

    private final void accept2(Context<?> ctx) {
        ctx.start(Clause.CREATE_SCHEMA_NAME).visit(Keywords.K_CREATE);
        if (SUPPORT_SCHEMA_AS_DATABASE.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_DATABASE);
        } else {
            ctx.sql(' ').visit(Keywords.K_SCHEMA);
        }
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.schema);
        ctx.end(Clause.CREATE_SCHEMA_NAME);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Schema $schema() {
        return this.schema;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final QOM.CreateSchema $schema(Schema newValue) {
        return this.$constructor().apply(newValue, (Boolean)this.$ifNotExists());
    }

    @Override
    public final QOM.CreateSchema $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$schema(), (Boolean)newValue);
    }

    public final Function2<? super Schema, ? super Boolean, ? extends QOM.CreateSchema> $constructor() {
        return (a1, a2) -> new CreateSchemaImpl(this.configuration(), (Schema)a1, (boolean)a2);
    }
}

