/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.JSONB;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Like;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class Contains<T>
extends AbstractCondition
implements QOM.Contains<T> {
    final Field<T> value;
    final Field<T> content;

    Contains(Field<T> value, Field<T> content) {
        this.value = Tools.nullableIf(false, Tools.nullSafe(value, content.getDataType()));
        this.content = Tools.nullableIf(false, Tools.nullSafe(content, value.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
            case CLICKHOUSE: 
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                return false;
            }
            case DERBY: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.value.getDataType().isArray() || this.content.getDataType().isArray()) {
                    ctx.visit(this.value).sql(" @> ").visit(this.content);
                    break;
                }
                if (this.value.getDataType().getType() == JSONB.class || this.content.getDataType().getType() == JSONB.class) {
                    ctx.visit(this.value).sql(" @> ").visit(this.content);
                    break;
                }
                this.acceptLike(ctx);
                break;
            }
            case CLICKHOUSE: 
            case CUBRID: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case TRINO: {
                this.acceptLike(ctx);
                break;
            }
            case DERBY: {
                this.acceptPosition(ctx);
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_CONTAINS, SQLDataType.BOOLEAN, this.value, this.content));
            }
        }
    }

    private final void acceptLike(Context<?> ctx) {
        ctx.visit(this.value.like(DSL.concat(DSL.inline("%"), Tools.escapeForLike(this.content, ctx.configuration()), DSL.inline("%")), '!'));
    }

    private final void acceptPosition(Context<?> ctx) {
        ctx.visit(DSL.position(Like.requiresStringCast(this.value), Like.requiresStringCast(this.content)).gt(DSL.inline(0)));
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<T> $arg2() {
        return this.content;
    }

    @Override
    public final QOM.Contains<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.Contains<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.Contains<T>> $constructor() {
        return (a1, a2) -> new Contains(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Contains) {
            QOM.Contains o = (QOM.Contains)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$content(), o.$content());
        }
        return super.equals(that);
    }
}

