/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Binding;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetResultSetContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetSQLInputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingGetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingRegisterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSQLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetSQLOutputContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.BindingSetStatementContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converters;
import io.lumine.mythic.bukkit.utils.lib.jooq.ResourceManagingScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Scope;
import io.lumine.mythic.bukkit.utils.lib.jooq.Source;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.ParamType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.jdbc.JDBCUtils;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Set;

public class ClobBinding
implements Binding<String, String> {
    static final Set<SQLDialect> NO_SUPPORT_NULL_LOBS = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
    static final Set<SQLDialect> NO_SUPPORT_LOBS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    @Override
    public final Converter<String, String> converter() {
        return Converters.identity(String.class);
    }

    @Override
    public final void sql(BindingSQLContext<String> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline((Object)ctx.convert(this.converter()).value(), SQLDataType.CLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public final void register(BindingRegisterContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.statement().registerOutParameter(ctx.index(), 2005);
        } else {
            ctx.statement().registerOutParameter(ctx.index(), 12);
        }
    }

    @Override
    public final void set(BindingSetStatementContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Clob clob = ClobBinding.newClob(ctx, ctx.value());
            if (clob == null && NO_SUPPORT_NULL_LOBS.contains((Object)ctx.dialect())) {
                ctx.statement().setNull(ctx.index(), 2005);
            } else {
                ctx.statement().setClob(ctx.index(), clob);
            }
        } else {
            ctx.statement().setString(ctx.index(), ctx.value());
        }
    }

    @Override
    public final void set(BindingSetSQLOutputContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.output().writeClob(ClobBinding.newClob(ctx, ctx.value()));
        } else {
            ctx.output().writeString(ctx.value());
        }
    }

    @Override
    public final void get(BindingGetResultSetContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Clob clob = ctx.resultSet().getClob(ctx.index());
            try {
                ctx.value(clob == null ? null : ClobBinding.read(ctx, clob));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.resultSet().getString(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetStatementContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Clob clob = ctx.statement().getClob(ctx.index());
            try {
                ctx.value(clob == null ? null : ClobBinding.read(ctx, clob));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.statement().getString(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<String> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Clob clob = ctx.input().readClob();
            try {
                ctx.value(clob == null ? null : ClobBinding.read(ctx, clob));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.input().readString());
        }
    }

    static final String read(Scope ctx, Clob clob) throws SQLException {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: {
                Reader r = clob.getCharacterStream();
                return r == null ? null : Source.of(r).readString();
            }
        }
        return clob.getSubString(1L, Tools.asInt(clob.length()));
    }

    static final Clob newClob(ResourceManagingScope scope, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (scope.dialect()) {
            default: 
        }
        Clob clob = DefaultExecuteContext.localConnection().createClob();
        scope.autoFree(clob);
        clob.setString(1L, string);
        return clob;
    }
}

