/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function1;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.util.UUID;

final class BinToUuid
extends AbstractField<UUID>
implements QOM.BinToUuid {
    final Field<byte[]> bytes;

    BinToUuid(Field<byte[]> bytes) {
        super(Names.N_BIN_TO_UUID, Tools.allNotNull(SQLDataType.UUID, bytes));
        this.bytes = Tools.nullSafeNotNull(bytes, SQLDataType.VARBINARY);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                return false;
            }
            case H2: 
            case HSQLDB: {
                return false;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: {
                ctx.visit(DSL.function(Names.N_UUIDNumToString, SQLDataType.UUID, this.bytes));
                break;
            }
            case H2: 
            case HSQLDB: {
                ctx.visit(DSL.cast(this.bytes, SQLDataType.UUID));
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(DSL.cast(DSL.function(Names.N_ENCODE, SQLDataType.VARCHAR(32), this.bytes, DSL.inline("hex")), SQLDataType.UUID));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_BIN_TO_UUID, this.getDataType(), this.bytes));
            }
        }
    }

    @Override
    public final Field<byte[]> $arg1() {
        return this.bytes;
    }

    @Override
    public final QOM.BinToUuid $arg1(Field<byte[]> newValue) {
        return this.$constructor().apply((Field<byte[]>)newValue);
    }

    @Override
    public final Function1<? super Field<byte[]>, ? extends QOM.BinToUuid> $constructor() {
        return a1 -> new BinToUuid((Field<byte[]>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.BinToUuid) {
            QOM.BinToUuid o = (QOM.BinToUuid)that;
            return StringUtils.equals(this.$bytes(), o.$bytes());
        }
        return super.equals(that);
    }
}

