/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.ContextConverter;
import io.lumine.mythic.bukkit.utils.lib.jooq.Converter;
import io.lumine.mythic.bukkit.utils.lib.jooq.ConverterContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.DataTypeException;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractContextConverter;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

public class AutoConverter<T, U>
extends AbstractContextConverter<T, U> {
    public AutoConverter(Class<T> fromType, Class<U> toType) {
        super(fromType, toType);
    }

    @Override
    public U from(T t2, ConverterContext ctx) {
        return this.delegate(ctx).from(t2, ctx);
    }

    @Override
    public T to(U u, ConverterContext ctx) {
        return this.delegate(ctx).to(u, ctx);
    }

    private final ContextConverter<T, U> delegate(ConverterContext ctx) {
        Converter c = ctx.configuration().converterProvider().provide(this.fromType(), this.toType());
        if (c == null) {
            c = Tools.CONFIG.get().converterProvider().provide(this.fromType(), this.toType());
        }
        if (c == null) {
            throw new DataTypeException("Cannot auto convert from " + String.valueOf(this.fromType()) + " to " + String.valueOf(this.toType()));
        }
        return ContextConverter.scoped(c);
    }

    @Override
    public String toString() {
        return "AutoConverter [ " + this.fromType().getName() + " -> " + this.toType().getName() + " ]";
    }
}

