/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Condition;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Param;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectFieldOrAsterisk;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectSelectStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractQueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class ArrayTableEmulation
extends AbstractQueryPart
implements QOM.UTransient {
    private final Object[] array;
    private final DataType<?> type;
    private final Name fieldAlias;
    private transient Select<?> table;

    ArrayTableEmulation(Object[] array, Name[] fieldAliases) {
        if (Tools.isEmpty(fieldAliases)) {
            this.fieldAlias = Names.N_COLUMN_VALUE;
        } else if (fieldAliases.length == 1) {
            this.fieldAlias = fieldAliases[0];
        } else {
            throw new IllegalArgumentException("Array table simulations can only have a single field alias");
        }
        this.array = array;
        this.type = Tools.componentDataType(array);
    }

    @Override
    public final void accept(Context<?> ctx) {
        Tools.visitSubquery(ctx, this.table(), 1, true);
    }

    private final Select<?> table() {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param<?> val = DSL.val(element, this.type);
                SelectSelectStep<Record> subselect = DSL.select(val.as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.select(DSL.one().as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = select;
        }
        return this.table;
    }
}

