/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.Select;
import io.lumine.mythic.bukkit.utils.lib.jooq.TableLike;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractCondition;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayOverlap<T>
extends AbstractCondition
implements QOM.ArrayOverlap<T> {
    final Field<T[]> array1;
    final Field<T[]> array2;

    ArrayOverlap(Field<T[]> array1, Field<T[]> array2) {
        this.array1 = Tools.nullSafeNotNull(array1, SQLDataType.OTHER.array());
        this.array2 = Tools.nullSafeNotNull(array2, SQLDataType.OTHER.array());
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                return false;
            }
            case H2: {
                return false;
            }
            case HSQLDB: {
                return false;
            }
            case TRINO: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                ctx.visit(DSL.cardinality(DSL.function(Names.N_ARRAY_INTERSECT, this.array1.getDataType(), this.array1, this.array2)).gt(DSL.inline(0)));
                break;
            }
            case H2: {
                ctx.visit(DSL.exists(DSL.select(DSL.asterisk()).from((TableLike<?>)DSL.unnest(this.array1)).intersect((Select)DSL.select(DSL.asterisk()).from((TableLike<?>)DSL.unnest(this.array2)))));
                break;
            }
            case HSQLDB: {
                ctx.visit(DSL.exists(DSL.select(DSL.asterisk()).from((TableLike<?>)DSL.unnest(this.array1)).intersectAll((Select)DSL.select(DSL.asterisk()).from((TableLike<?>)DSL.unnest(this.array2)))));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_ARRAYS_OVERLAP, SQLDataType.BOOLEAN, this.array1, this.array2));
                break;
            }
            default: {
                ctx.sql('(').visit(this.array1).sql(" && ").visit(this.array2).sql(')');
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array1;
    }

    @Override
    public final Field<T[]> $arg2() {
        return this.array2;
    }

    @Override
    public final QOM.ArrayOverlap<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T[]>)this.$arg2());
    }

    @Override
    public final QOM.ArrayOverlap<T> $arg2(Field<T[]> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T[]>, ? extends QOM.ArrayOverlap<T>> $constructor() {
        return (a1, a2) -> new ArrayOverlap((Field<T[]>)a1, (Field<T[]>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayOverlap) {
            QOM.ArrayOverlap o = (QOM.ArrayOverlap)that;
            return StringUtils.equals(this.$array1(), o.$array1()) && StringUtils.equals(this.$array2(), o.$array2());
        }
        return super.equals(that);
    }
}

