/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.CharacterSet;
import io.lumine.mythic.bukkit.utils.lib.jooq.Collation;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Generator;
import io.lumine.mythic.bukkit.utils.lib.jooq.Nullability;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;

final class ArrayDataType<T>
extends DefaultDataType<T[]> {
    final DataType<T> elementType;

    public ArrayDataType(DataType<T> elementType) {
        super(null, elementType.getArrayType(), elementType.getTypeName() + " array", elementType.getCastTypeName() + " array");
        this.elementType = elementType;
    }

    ArrayDataType(AbstractDataType<T[]> t2, DataType<T> elementType, Integer precision, Integer scale, Integer length, Nullability nullability, boolean hidden, boolean readonly, Generator<?, ?, T[]> generatedAlwaysAs, QOM.GenerationOption generationOption, QOM.GenerationLocation generationLocation, Collation collation, CharacterSet characterSet, boolean identity, Field<T[]> defaultValue) {
        super(t2, precision, scale, length, nullability, hidden, readonly, generatedAlwaysAs, generationOption, generationLocation, collation, characterSet, identity, defaultValue);
        this.elementType = elementType;
    }

    @Override
    DefaultDataType<T[]> construct(Integer newPrecision, Integer newScale, Integer newLength, Nullability newNullability, boolean newHidden, boolean newReadonly, Generator<?, ?, T[]> newGeneratedAlwaysAs, QOM.GenerationOption newGenerationOption, QOM.GenerationLocation newGenerationLocation, Collation newCollation, CharacterSet newCharacterSet, boolean newIdentity, Field<T[]> newDefaultValue) {
        return new ArrayDataType<T>(this, (AbstractDataType)this.elementType, newPrecision, newScale, newLength, newNullability, newHidden, newReadonly, newGeneratedAlwaysAs, newGenerationOption, newGenerationLocation, newCollation, newCharacterSet, newIdentity, newDefaultValue);
    }

    @Override
    public final String getTypeName() {
        return this.getTypeName(Tools.CONFIG.get());
    }

    @Override
    public final String getTypeName(Configuration configuration) {
        String typeName = this.elementType.getTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, typeName);
    }

    @Override
    public final String getCastTypeName() {
        return this.getCastTypeName(Tools.CONFIG.get());
    }

    @Override
    public final String getCastTypeName(Configuration configuration) {
        String castTypeName = this.elementType.getCastTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, castTypeName);
    }

    @Override
    public final Row getRow() {
        return this.elementType.getRow();
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return this.elementType.getRecordType();
    }

    @Override
    public final Class<?> getArrayComponentType() {
        return this.elementType.getType();
    }

    @Override
    public final DataType<?> getArrayComponentDataType() {
        return this.elementType;
    }

    @Override
    public final Class<?> getArrayBaseType() {
        return this.getArrayBaseDataType().getType();
    }

    @Override
    public final DataType<?> getArrayBaseDataType() {
        DataType<?> t2;
        DataType<T[]> result = this;
        while ((t2 = result.getArrayComponentDataType()) != null) {
            result = t2;
        }
        return result;
    }

    private static String getArrayType(Configuration configuration, String dataType) {
        if (DefaultDataType.SUPPORT_POSTGRES_SUFFIX_ARRAY_NOTATION.contains((Object)configuration.dialect())) {
            return dataType + "[]";
        }
        if (DefaultDataType.SUPPORT_TRINO_ARRAY_NOTATION.contains((Object)configuration.dialect())) {
            return "Array(" + dataType + ")";
        }
        return dataType + " array";
    }
}

