/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.AlterDatabaseFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.AlterDatabaseStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Catalog;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function3;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class AlterDatabaseImpl
extends AbstractDDLQuery
implements QOM.AlterDatabase,
AlterDatabaseStep,
AlterDatabaseFinalStep {
    final Catalog database;
    final boolean ifExists;
    Catalog renameTo;
    static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_RENAME_DATABASE = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);

    AlterDatabaseImpl(Configuration configuration, Catalog database, boolean ifExists) {
        this(configuration, database, ifExists, null);
    }

    AlterDatabaseImpl(Configuration configuration, Catalog database, boolean ifExists, Catalog renameTo) {
        super(configuration);
        this.database = database;
        this.ifExists = ifExists;
        this.renameTo = renameTo;
    }

    @Override
    public final AlterDatabaseImpl renameTo(String renameTo) {
        return this.renameTo(DSL.catalog(DSL.name(renameTo)));
    }

    @Override
    public final AlterDatabaseImpl renameTo(Name renameTo) {
        return this.renameTo(DSL.catalog(renameTo));
    }

    @Override
    public final AlterDatabaseImpl renameTo(Catalog renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_DATABASE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean supportRename = SUPPORT_RENAME_DATABASE.contains((Object)ctx.dialect());
        if (supportRename) {
            ctx.visit(Keywords.K_RENAME);
        } else {
            ctx.visit(Keywords.K_ALTER);
        }
        ctx.sql(' ').visit(Keywords.K_DATABASE);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
        if (this.renameTo != null) {
            ctx.sql(' ').visit(supportRename ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo));
        }
    }

    @Override
    public final Catalog $database() {
        return this.database;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final Catalog $renameTo() {
        return this.renameTo;
    }

    @Override
    public final QOM.AlterDatabase $database(Catalog newValue) {
        return this.$constructor().apply(newValue, (Boolean)this.$ifExists(), this.$renameTo());
    }

    @Override
    public final QOM.AlterDatabase $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$database(), (Boolean)newValue, this.$renameTo());
    }

    @Override
    public final QOM.AlterDatabase $renameTo(Catalog newValue) {
        return this.$constructor().apply(this.$database(), (Boolean)this.$ifExists(), newValue);
    }

    public final Function3<? super Catalog, ? super Boolean, ? super Catalog, ? extends QOM.AlterDatabase> $constructor() {
        return (a1, a2, a3) -> new AlterDatabaseImpl(this.configuration(), (Catalog)a1, (boolean)a2, (Catalog)a3);
    }
}

