/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Fields;
import io.lumine.mythic.bukkit.utils.lib.jooq.Name;
import io.lumine.mythic.bukkit.utils.lib.jooq.Record;
import io.lumine.mythic.bukkit.utils.lib.jooq.Row;
import io.lumine.mythic.bukkit.utils.lib.jooq.SelectField;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.RenderQuotedNames;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractRow;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AutoAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.FieldAlias;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Multiset;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.RowAsField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.JooqLogger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

abstract class AbstractRowAsField<R extends Record>
extends AbstractField<R>
implements AutoAlias<SelectField<R>> {
    private static final JooqLogger logNamePathSeparator = JooqLogger.getLogger(AbstractRowAsField.class, 3);

    AbstractRowAsField(Name name, DataType<R> type) {
        super(name, type);
    }

    abstract Fields fields0();

    abstract Class<R> getRecordType();

    final AbstractRow<R> emulatedFields(Configuration configuration) {
        String s2 = configuration.settings().getNamePathSeparator();
        if (".".equals(s2) && configuration.settings().getRenderQuotedNames() == RenderQuotedNames.NEVER && logNamePathSeparator.isWarnEnabled()) {
            logNamePathSeparator.warn((Object)"Unquoted identifiers", "Settings.renderQuotedNames disables quoting and Settings.namePathSeparator is the default (\".\"), which can cause problems when nesting records. Consider quoting identifiers or specifying a different Settings.namePathSeparator.");
        }
        return Tools.row0(Tools.map(this.fields0().fields(), x -> x.as(DSL.quotedName(Tools.sanitiseName(configuration, String.valueOf(this.getUnqualifiedName().unquotedName()) + s2 + x.getName()))), Field[]::new));
    }

    @Override
    final int projectionSize() {
        int result = 0;
        for (Field<?> field : this.fields0().fields()) {
            result += ((AbstractField)field).projectionSize();
        }
        return result;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (AbstractRowAsField.forceMultisetContent(ctx, () -> this.getDataType().getRow().size() > 1)) {
            AbstractRowAsField.acceptMultisetContent(ctx, this.getDataType().getRow(), this, this::acceptDefault);
        } else {
            this.acceptDefault(ctx);
        }
    }

    static final boolean forceMultisetContent(Context<?> ctx, BooleanSupplier degreeCheck) {
        return Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT)) || ctx.subquery() && RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect()) && !ctx.predicandSubquery() && !ctx.derivedTableSubquery() && !ctx.setOperationSubquery() && degreeCheck.getAsBoolean();
    }

    static final boolean forceRowContent(Context<?> ctx) {
        return Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_ROW_CONTENT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void acceptMultisetContent(Context<?> ctx, Row row, Field<?> field, Consumer<? super Context<?>> acceptDefault) {
        Object previous = ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT);
        try {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true);
            Name alias = field.getUnqualifiedName();
            switch (Tools.emulateMultiset(ctx.configuration())) {
                case JSON: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, Multiset.returningClob(ctx, DSL.jsonArray(row.fields()).nullOnNull())));
                    return;
                }
                case JSONB: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, Multiset.returningClob(ctx, DSL.jsonbArray(row.fields()).nullOnNull())));
                    return;
                }
                case XML: {
                    switch (ctx.family()) {
                        default: 
                    }
                    ctx.visit(AbstractRowAsField.alias(ctx, alias, DSL.xmlelement(Names.N_RECORD, Tools.map(row.fields(), (f, i) -> Multiset.wrapXmlelement(ctx, f, Tools.fieldNameString(i))))));
                    return;
                }
                default: {
                    acceptDefault.accept(ctx);
                    return;
                }
            }
        }
        finally {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, previous);
        }
    }

    @Override
    public final SelectField<R> autoAlias(Context<?> ctx, SelectField<R> s2) {
        if (RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            return s2;
        }
        if (AbstractRowAsField.forceMultisetContent(ctx, () -> this.getDataType().getRow().size() > 1)) {
            return s2;
        }
        return new FieldAlias<R>(DSL.field(s2), this.getUnqualifiedName());
    }

    private static final Field<?> alias(Context<?> ctx, Name alias, Field<?> field) {
        return ctx.declareFields() ? field.as(alias) : field;
    }

    abstract void acceptDefault(Context<?> var1);
}

