/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.DSLContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.SettingsTools;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractScope;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ParserException;
import java.util.Locale;

abstract class AbstractParseContext
extends AbstractScope {
    final DSLContext dsl;
    final Locale locale;
    char[] chars;
    int position = 0;
    int positionBeforeWhitespace;

    public AbstractParseContext(DSLContext dsl, String chars) {
        super(dsl.configuration());
        this.dsl = dsl;
        this.locale = SettingsTools.parseLocale(dsl.settings());
        this.chars = chars != null ? chars.toCharArray() : new char[]{};
    }

    final boolean hasMore() {
        return this.position < this.chars.length;
    }

    final boolean hasMore(int offset) {
        return this.position + offset < this.chars.length;
    }

    boolean done() {
        return this.position >= this.chars.length;
    }

    final String mark() {
        int[] line = this.line();
        return "[" + line[0] + ":" + line[1] + "] " + (this.position > 50 ? "..." : "") + this.substring(Math.max(0, this.position - 50), this.position) + "[*]" + this.substring(this.position, Math.min(this.chars.length, this.position + 80)) + (this.chars.length > this.position + 80 ? "..." : "");
    }

    final int[] line() {
        int line = 1;
        int column = 1;
        for (int i = 0; i < this.position; ++i) {
            if (this.chars[i] == '\r') {
                ++line;
                column = 1;
                if (i + 1 >= this.chars.length || this.chars[i + 1] != '\n') continue;
                ++i;
                continue;
            }
            if (this.chars[i] == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return new int[]{line, column};
    }

    final double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw this.expected("Double literal");
        }
    }

    final int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw this.expected("Integer literal");
        }
    }

    final int parseInt(String string, int base) {
        try {
            return Integer.parseInt(string, base);
        }
        catch (NumberFormatException e) {
            throw this.expected("Integer literal of base: " + base);
        }
    }

    final String substring(int startPosition, int endPosition) {
        startPosition = Math.max(0, startPosition);
        endPosition = Math.min(this.chars.length, endPosition);
        return new String(this.chars, startPosition, Math.min(endPosition - startPosition, this.chars.length - startPosition));
    }

    final ParserException internalError() {
        return this.exception("Internal Error");
    }

    final ParserException expected(String object) {
        return this.init(new ParserException(this.mark(), object + " expected"));
    }

    final ParserException expected(String ... objects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i == 0) {
                sb.append(objects[i]);
                continue;
            }
            if (i == 1 && objects.length == 2) {
                sb.append(" or ").append(objects[i]);
                continue;
            }
            if (i == objects.length - 1) {
                sb.append(", or ").append(objects[i]);
                continue;
            }
            sb.append(", ").append(objects[i]);
        }
        return this.init(new ParserException(this.mark(), sb.toString() + " expected"));
    }

    public final ParserException exception(String message) {
        return this.init(new ParserException(this.mark(), message));
    }

    final ParserException init(ParserException e) {
        int[] line = this.line();
        return e.position(this.position).line(line[0]).column(line[1]);
    }

    final char characterUpper() {
        return Character.toUpperCase(this.character());
    }

    public final char character() {
        return this.character(this.position);
    }

    public final char character(int pos) {
        return pos >= 0 && pos < this.chars.length ? this.chars[pos] : (char)' ';
    }

    final char characterNextUpper() {
        return Character.toUpperCase(this.characterNext());
    }

    final char characterNext() {
        return this.character(this.position + 1);
    }

    public final char[] characters() {
        return this.chars;
    }

    public final int position() {
        return this.position;
    }

    public final boolean position(int newPosition) {
        this.position = newPosition;
        return true;
    }

    final boolean positionInc() {
        return this.positionInc(1);
    }

    final boolean positionInc(int inc) {
        return this.position(this.position + inc);
    }

    final boolean parseWhitespaceIf() {
        this.positionBeforeWhitespace = this.position();
        this.position(this.afterWhitespace(this.positionBeforeWhitespace));
        return this.positionBeforeWhitespace != this.position();
    }

    abstract int afterWhitespace(int var1);

    final char lower(char c) {
        return c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
    }

    final char upper(char c) {
        return c >= 'a' && c <= 'z' ? (char)(c - 32) : c;
    }

    final boolean parseTokens(char ... tokens) {
        boolean result = this.parseTokensIf(tokens);
        if (!result) {
            throw this.expected(new String(tokens));
        }
        return result;
    }

    final boolean parseTokensIf(char ... tokens) {
        int p = this.position();
        for (char token : tokens) {
            if (this.parseIf(token)) continue;
            this.position(p);
            return false;
        }
        return true;
    }

    final boolean peekTokens(char ... tokens) {
        int p = this.position();
        for (char token : tokens) {
            if (this.parseIf(token)) continue;
            this.position(p);
            return false;
        }
        this.position(p);
        return true;
    }

    public final boolean parse(String string) {
        boolean result = this.parseIf(string);
        if (!result) {
            throw this.expected(string);
        }
        return result;
    }

    public final boolean parseIf(String string) {
        return this.parseIf(string, true);
    }

    final boolean parseIf(String string, boolean skipAfterWhitespace) {
        boolean result = this.peek(string);
        if (result) {
            this.positionInc(string.length());
            if (skipAfterWhitespace) {
                this.parseWhitespaceIf();
            }
        }
        return result;
    }

    public final boolean parse(char c) {
        return this.parse(c, true);
    }

    final boolean parse(char c, boolean skipAfterWhitespace) {
        if (!this.parseIf(c, skipAfterWhitespace)) {
            throw this.expected("Token '" + c + "'");
        }
        return true;
    }

    public final boolean parseIf(char c) {
        return this.parseIf(c, true);
    }

    final boolean parseIf(char c, boolean skipAfterWhitespace) {
        boolean result = this.peek(c);
        if (result) {
            this.positionInc();
            if (skipAfterWhitespace) {
                this.parseWhitespaceIf();
            }
        }
        return result;
    }

    final boolean parseIf(char c, char peek, boolean skipAfterWhitespace) {
        if (this.character() != c) {
            return false;
        }
        if (this.characterNext() != peek) {
            return false;
        }
        this.positionInc();
        if (skipAfterWhitespace) {
            this.parseWhitespaceIf();
        }
        return true;
    }

    public final boolean peek(char c) {
        return this.character() == c;
    }

    final boolean peek(char c, int p) {
        return this.character(p) == c;
    }

    public final boolean peek(String string) {
        return this.peek(string, this.position());
    }

    final boolean peek(String string, int p) {
        int length = string.length();
        if (this.chars.length < p + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.chars[p + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

