/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.items;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.annotation.NonnullByDefault;
import io.lumine.mythic.bukkit.utils.config.LineConfig;
import io.lumine.mythic.bukkit.utils.items.nbt.jnbt.CompoundTagBuilder;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.menu.PaperComponentHelper;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.bukkit.utils.serialize.Chroma;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.bukkit.utils.version.wrappers.VersionWrapper;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@NonnullByDefault
public class ItemFactory {
    private ItemStack itemStack;
    private boolean clone = true;

    public static ItemFactory of(Material material) {
        return new ItemFactory(new ItemStack(material));
    }

    public static ItemFactory of(ItemStack itemStack) {
        return new ItemFactory(itemStack);
    }

    public static ItemFactory of(String line) {
        return ItemFactory.of(LineConfig.of(line));
    }

    public static ItemFactory of(LineConfig lc) {
        String[] split;
        Material material = Material.STONE;
        String mat = lc.getKey();
        if (mat.contains(" ")) {
            mat = mat.split(" ")[0];
        }
        try {
            material = Material.valueOf((String)mat.toUpperCase());
        }
        catch (Exception ex) {
            Log.info("Invalid item material {0} on line {1}", mat, lc.getLine());
        }
        ItemFactory factory = ItemFactory.of(material);
        String display = lc.getString(new String[]{"name", "display", "n", "d"}, null, new String[0]);
        int data = lc.getInteger(new String[]{"data"}, 0);
        int model = lc.getInteger(new String[]{"model"}, 0);
        int amount = lc.getInteger(new String[]{"amount", "a"}, 1);
        String lore = lc.getString(new String[]{"lore", "l"}, null, new String[0]);
        String enchantments = lc.getString(new String[]{"enchantments", "enchants", "ench", "e"}, null, new String[0]);
        String potionEffects = lc.getString(new String[]{"potioneffects", "peffects", "potion", "pe"}, null, new String[0]);
        String color = lc.getString(new String[]{"color", "c", "potioncolor", "pcolor", "pc"}, null, new String[0]);
        String skullOwner = lc.getString(new String[]{"skullowner"}, null, new String[0]);
        String skullTexture = lc.getString(new String[]{"skulltexture"}, null, new String[0]);
        if (display != null) {
            if (display.startsWith("\"")) {
                display = display.substring(1, display.length() - 1);
            }
            display = LineConfig.parseSpecialChars(display);
            factory.name(display);
        }
        if (data > 0) {
            factory.data((byte)data);
        }
        if (model > 0) {
            factory.model(model);
        }
        if (amount != 1) {
            factory.amount(amount);
        }
        if (lore != null) {
            try {
                ArrayList<String> loreList = new ArrayList<String>();
                String[] stringArray = lore.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s2 = stringArray[i];
                    String lores = s2.substring(1, s2.length() - 1);
                    lores = LineConfig.parseSpecialChars(lores);
                    loreList.add(lores);
                }
                factory.lore(loreList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (enchantments != null) {
            try {
                for (String s3 : enchantments.split(",")) {
                    try {
                        split = s3.split(":");
                        String enchantName = split[0];
                        Enchantment ench = enchantName.equalsIgnoreCase("random") ? Enchantment.values()[Numbers.randomInt(Enchantment.values().length)] : Enchantment.getByName((String)enchantName);
                        int level = new RandomInt(split[1]).get();
                        factory.enchant(ench, level);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured enchantment");
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (potionEffects != null) {
            try {
                for (String s4 : potionEffects.split(",")) {
                    try {
                        split = s4.split(":");
                        PotionEffectType type = PotionEffectType.getByName((String)split[0].toUpperCase());
                        int duration = Integer.parseInt(split[1]);
                        int amplifier = 0;
                        if (split.length > 2) {
                            amplifier = Integer.parseInt(split[2]);
                        }
                        factory.potionEffect(type, duration, amplifier);
                    }
                    catch (Exception ex) {
                        Log.error("Badly configured potion effect " + s4);
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (color != null) {
            factory.color(color);
        }
        if (skullOwner != null) {
            factory.skullOwner(skullOwner);
        }
        return factory;
    }

    protected ItemFactory() {
        this.itemStack = new ItemStack(Material.STONE);
    }

    protected ItemFactory(ItemStack itemStack) {
        this.itemStack = Objects.requireNonNull(itemStack, "itemStack");
    }

    public ItemFactory transform(Consumer<ItemStack> is) {
        is.accept(this.itemStack);
        return this;
    }

    public ItemFactory transformMeta(Consumer<ItemMeta> meta) {
        ItemMeta m4 = this.itemStack.getItemMeta();
        if (m4 != null) {
            meta.accept(m4);
            this.itemStack.setItemMeta(m4);
        }
        return this;
    }

    public ItemFactory name(String name) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> meta.displayName(Text.parse(name)));
        }
        return this.transformMeta(meta -> meta.setDisplayName(Text.colorizeLegacy(name)));
    }

    public ItemFactory type(Material material) {
        return this.transform(itemStack -> itemStack.setType(material));
    }

    public ItemFactory lore(String line) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                lore.add(Text.parse(line));
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add(Text.colorize(line));
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(String ... lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(Iterable<String> lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory lore(Function<List<String>, Iterable<String>> linesFunc) {
        Iterable<String> lines = linesFunc.apply(Lists.newArrayList());
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory clearLore() {
        return this.transformMeta(meta -> meta.setLore(new ArrayList()));
    }

    public ItemFactory prependLore(String line) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List<Component> lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                lore.add(0, Text.parse(line));
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            List<String> lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            lore.add(0, Text.colorize(line));
            meta.setLore(lore);
        });
    }

    public ItemFactory prependLore(String ... lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                ArrayList<Object> extraLore = new ArrayList<Object>();
                for (String line : lines) {
                    extraLore.add(Text.parse(line));
                }
                extraLore.addAll(lore);
                meta.lore(extraLore);
            });
        }
        return this.transformMeta(meta -> {
            List lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            ArrayList<String> extraLore = new ArrayList<String>();
            for (String line : lines) {
                extraLore.add(Text.colorize(line));
            }
            extraLore.addAll(lore);
            meta.setLore(extraLore);
        });
    }

    public ItemFactory prependLore(Iterable<String> lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                List lore = meta.getLore() == null ? new ArrayList() : meta.lore();
                ArrayList<Object> extraLore = new ArrayList<Object>();
                for (String line : lines) {
                    extraLore.add(Text.parse(line));
                }
                extraLore.addAll(lore);
                meta.lore(extraLore);
            });
        }
        return this.transformMeta(meta -> {
            List lore = meta.getLore() == null ? new ArrayList() : meta.getLore();
            ArrayList<String> extraLore = new ArrayList<String>();
            for (String line : lines) {
                extraLore.add(Text.colorize(line));
            }
            extraLore.addAll(lore);
            meta.setLore(extraLore);
        });
    }

    public ItemFactory prependLore(Function<List<String>, Iterable<String>> linesFunc) {
        return this.prependLore(linesFunc.apply(Lists.newArrayList()));
    }

    public ItemFactory setLore(String line) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                ArrayList<Component> lore = new ArrayList<Component>();
                lore.add(Text.parse(line));
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(Text.colorize(line));
            meta.setLore(lore);
        });
    }

    public ItemFactory setLore(String ... lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                ArrayList<Component> lore = new ArrayList<Component>();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory setLore(Iterable<String> lines) {
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                ArrayList<Component> lore = new ArrayList<Component>();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory setLore(Function<List<String>, Iterable<String>> linesFunc) {
        Iterable<String> lines = linesFunc.apply(Lists.newArrayList());
        if (ServerVersion.isPaper() && ServerVersion.isAfterOrEq(MinecraftVersions.v1_16)) {
            return this.transformMeta(meta -> {
                ArrayList<Component> lore = new ArrayList<Component>();
                for (String line : lines) {
                    lore.add(Text.parse(line));
                }
                meta.lore(lore);
            });
        }
        return this.transformMeta(meta -> {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : lines) {
                lore.add(Text.colorize(line));
            }
            meta.setLore(lore);
        });
    }

    public ItemFactory durability(int durability) {
        if (ServerVersion.isBefore(MinecraftVersions.v1_15)) {
            return this.transform(itemStack -> itemStack.setDurability((short)durability));
        }
        return this.transformMeta(meta -> {
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(durability);
            }
        });
    }

    public ItemFactory data(int data) {
        return this.durability(data);
    }

    public ItemFactory amount(int amount) {
        return this.transform(itemStack -> {
            if (amount > itemStack.getMaxStackSize()) {
                itemStack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)99);
            }
            itemStack.setAmount(amount);
        });
    }

    @Deprecated
    public ItemFactory model(int model) {
        return this.transformMeta(meta -> meta.setCustomModelData(Integer.valueOf(model)));
    }

    public ItemFactory itemModel(String model) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3) && model != null) {
            PaperComponentHelper.setItemModelComponent(this.itemStack, model);
        }
        return this;
    }

    public ItemFactory itemModel(NamespacedKey model) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3) && model != null) {
            PaperComponentHelper.setItemModelComponent(this.itemStack, model);
        }
        return this;
    }

    public ItemFactory customModelData(int model) {
        return this.transformMeta(meta -> meta.setCustomModelData(Integer.valueOf(model)));
    }

    public ItemFactory enchant(Enchantment enchantment, int level) {
        return this.transform(itemStack -> {
            if (itemStack.getType() != Material.ENCHANTED_BOOK) {
                itemStack.addUnsafeEnchantment(enchantment, level);
            } else {
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)itemStack.getItemMeta();
                esm.addStoredEnchant(enchantment, level, true);
                itemStack.setItemMeta((ItemMeta)esm);
            }
        });
    }

    public ItemFactory enchant(Enchantment enchantment) {
        return this.enchant(enchantment, 1);
    }

    public ItemFactory clearEnchantments() {
        return this.transform(itemStack -> itemStack.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)itemStack).removeEnchantment(arg_0)));
    }

    public ItemFactory glint(boolean enabled) {
        return this.transformMeta(meta -> meta.setEnchantmentGlintOverride(Boolean.valueOf(enabled)));
    }

    public ItemFactory potionEffect(PotionEffectType type, int duration, int amplifier) {
        return this.transformMeta(meta -> {
            if (meta instanceof PotionMeta) {
                PotionMeta pMeta = (PotionMeta)meta;
                PotionEffect effect = new PotionEffect(type, duration, amplifier);
                pMeta.addCustomEffect(effect, true);
            }
        });
    }

    public ItemFactory potionEffect(PotionEffectType type, int duration) {
        return this.potionEffect(type, duration, 0);
    }

    public ItemFactory clearPotionEffects() {
        return this.transformMeta(meta -> {
            if (meta instanceof PotionMeta) {
                PotionMeta pMeta = (PotionMeta)meta;
                pMeta.clearCustomEffects();
            }
        });
    }

    public ItemFactory color(String colorCode) {
        return this.color(Chroma.of(colorCode));
    }

    public ItemFactory color(Chroma color) {
        return this.transformMeta(meta -> {
            if (meta instanceof PotionMeta) {
                PotionMeta pMeta = (PotionMeta)meta;
                pMeta.setColor(color.toBukkitColor());
            } else if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta pMeta = (LeatherArmorMeta)meta;
                pMeta.setColor(color.toBukkitColor());
            }
        });
    }

    public ItemFactory flag(Collection<ItemFlag> flags) {
        return this.transformMeta(meta -> flags.forEach(flag -> meta.addItemFlags(new ItemFlag[]{flag})));
    }

    public ItemFactory unflag(Collection<ItemFlag> flags) {
        return this.transformMeta(meta -> flags.forEach(flag -> meta.removeItemFlags(new ItemFlag[]{flag})));
    }

    public ItemFactory flag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.addItemFlags(flags));
    }

    public ItemFactory unflag(ItemFlag ... flags) {
        return this.transformMeta(meta -> meta.removeItemFlags(flags));
    }

    public ItemFactory hideAttributes() {
        return this.flag(ItemFlag.values());
    }

    public ItemFactory showAttributes() {
        return this.unflag(ItemFlag.values());
    }

    public ItemFactory color(Color color) {
        return this.transform(itemStack -> {
            Material type = itemStack.getType();
            if (type == Material.LEATHER_BOOTS || type == Material.LEATHER_CHESTPLATE || type == Material.LEATHER_HELMET || type == Material.LEATHER_LEGGINGS) {
                LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
                meta.setColor(color);
                itemStack.setItemMeta((ItemMeta)meta);
            }
        });
    }

    public ItemFactory breakable(boolean flag) {
        return this.transformMeta(meta -> meta.setUnbreakable(!flag));
    }

    public ItemFactory skullOwner(String owner) {
        if (VersionWrapper.isSupported()) {
            return this.nbt(tag -> tag.putString("SkullOwner", owner));
        }
        return this.transformMeta(meta -> {
            if (!(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta im = (SkullMeta)meta;
            im.setOwner(owner);
        });
    }

    public ItemFactory apply(Consumer<ItemFactory> consumer) {
        consumer.accept(this);
        return this;
    }

    public ItemFactory pdc(Consumer<PersistentDataContainer> consumer) {
        return this.transformMeta(meta -> consumer.accept(meta.getPersistentDataContainer()));
    }

    public ItemFactory nbt(Consumer<CompoundTagBuilder> consumer) {
        VersionWrapper version = VersionWrapper.get();
        if (version == null) {
            Log.error("ItemFactory NBT Modification not supported on this version");
            return this;
        }
        CompoundTagBuilder tag = version.getItemHandler().getCompoundTag(this.itemStack).createBuilder();
        consumer.accept(tag);
        this.itemStack = version.getItemHandler().setCompoundTag(this.itemStack, tag.build());
        return this;
    }

    public ItemStack peek() {
        return this.itemStack;
    }

    public ItemStack build() {
        return this.itemStack.clone();
    }
}

